// Copyright (C) 1997-1999  Adrian Trapletti
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//
// Set of integers class
//


#ifndef _INTSET_HH_
#define _INTSET_HH_


class intset  
{
private:
  int cursize;
  int maxval;
  int* x;

public:
  intset (int n = 1);  // subset of {1..n}
  ~intset (); 
#ifdef CHECK  
  int member (int t) const;  // is "t" a member?
#else
  int member (int t) const { return x[t-1] == 1; }
#endif
  void remove (int t);  // remove "t" from set
  void insert (int t);  // add "t" to set
  
  int empty () const          { return cursize == 0; }        
  int size () const           { return cursize; }
};


#endif  // _INTSET_HH_








