/* Copyright (C) 1997-1999  Adrian Trapletti
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
  
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   extensions to numerical recipes procedures */


#ifndef _NREXT_H_
#define _NREXT_H_


#define NO    0  /* type of output the optimizers should produce */
#define PRINT 1
#define RPLOT 2


extern long init_ran2;  /* seed value for the random number generator ran2() */


extern void RPERM (int n, int k, int I[]);
extern int det_chol (double **a, int n, double* det);
extern int inv_chol (double **a, int n);
extern void grddsc (double p[], int n, double eta, double alpha, double ftol, 
		    int *iter, double *fret, double (*func)(double []), 
		    void (*dfunc)(double [], double []), int trace, int ITMAX);
extern void stpdsc (double p[], int n, double ftol, int *iter, double *fret,
		    double (*func)(double []), void (*dfunc)(double [], double []), 
		    int trace, int ITMAX);
extern void sann (double pb[], double *yb, long n, int itmax, int kmax, 
		  double ti, double (*func)(double []), int trace);
extern void nrsann (double pb[], double *yb, long n, int itmax, int kmax, 
		    double ti, double (*func)(double []), int trace);
extern double numdf (double (*f)(double), double x);
#ifdef RFLAG
extern void R_plot (int its, double fp);
#endif


#endif  /* _NREXT_H_ */


