/* Copyright (C) 1997-1999  Adrian Trapletti
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
  
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   Linear algebra package for C */


#ifndef _NRLINAL_H_
#define _NRLINAL_H_


#define GAUSS   0  /* random number distribution */
#define UNIFORM 1


extern void vEQvPLv (double *x, double *y, double *z, long n);  
extern void vEQvMIv (double *x, double *y, double *z, long n);  
extern void vEQvTIv (double *x, double *y, double *z, long n);  
extern void vEQvDIv (double *x, double *y, double *z, long n);  
extern void vPLEQv (double *x, double *y, long n);  
extern void vMIEQv (double *x, double *y, long n);  
extern void vTIEQv (double *x, double *y, long n);  
extern void vDIEQv (double *x, double *y, long n);  
extern void vPLEQd (double *x, double y, long n);  
extern void vMIEQd (double *x, double y, long n);  
extern void vTIEQd (double *x, double y, long n);  
extern void vDIEQd (double *x, double y, long n);  
extern void vEQvPLd (double *x, double *y, double z, long n);  
extern void vEQvMId (double *x, double *y, double z, long n);  
extern void vEQvTId (double *x, double *y, double z, long n);  
extern void vEQvDId (double *x, double *y, double z, long n); 
extern void vEQmTIv (double *x, double **y, double *z, long n, long m);   
extern void vEQMIv (double *x, double *y, long n);
extern void mEQmPLm (double **x, double **y, double **z, long n, long m);  
extern void mEQmMIm (double **x, double **y, double **z, long n, long m);  
extern void mEQmTIm (double **x, double **y, double **z, long n, long m);  
extern void mEQmDIm (double **x, double **y, double **z, long n, long m);  
extern void mEQmMTIm (double **x, double **y, double **z, long n, long m, long p);  
extern void mPLEQm (double **x, double **y, long n, long m);  
extern void mMIEQm (double **x, double **y, long n, long m);  
extern void mTIEQm (double **x, double **y, long n, long m);  
extern void mDIEQm (double **x, double **y, long n, long m);  
extern void mPLEQd (double **x, double y, long n, long m);  
extern void mMIEQd (double **x, double y, long n, long m);  
extern void mTIEQd (double **x, double y, long n, long m);  
extern void mDIEQd (double **x, double y, long n, long m);  
extern void mEQmPLd (double **x, double **y, double z, long n, long m);  
extern void mEQmMId (double **x, double **y, double z, long n, long m);  
extern void mEQmTId (double **x, double **y, double z, long n, long m);  
extern void mEQmDId (double **x, double **y, double z, long n, long m); 
extern void mEQMIm (double **x, double **y, long n, long m);
extern void OUTER (double **x, double *y, double *z, long n);
extern double INNER (double *x, double *y, long n);
extern double SUMv (double *x, long n);
extern double MEANv (double *x, long n);
extern void RANDv (double *x, long n, int type, double mean, double var);
extern void RANDm (double **x, long n, long m, int type, double mean, double var);
extern void ZEROv (double *x, long n);
extern void ONEv (double *x, long n);
extern void ZEROm (double **x, long n, long m);
extern void ONEm (double **x, long n, long m);  
extern void EYEm (double **x, long n); 


#endif  /* _NRLINAL_H_ */

