// Copyright (C) 1997-1999  Adrian Trapletti
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//
// Utilities
//


#include <iostream.h>
#include "utils.hh"
#ifdef RFLAG
#include "R.h"
#endif


void RTerror (const char* mod, const char* proc, const char* errc)  // write error message and exit
{
  cerr << "Run-time error..." << endl;
  cerr << "Module " << mod << ", Procedure " << proc << ", Error Code " << errc << endl;
  cerr << "...now exiting..." << endl;
#ifdef RFLAG
  error ("Returning to R\n");
#else
  exit (1);
#endif
}

void RTerror (const char* mod, const char* proc)
{
  cerr << "Run-time error..." << endl;
  cerr << "Module " << mod << ", Procedure " << proc << endl;
  cerr << "...now exiting..." << endl;
#ifdef RFLAG
  error ("Returning to R\n");
#else
  exit (1);
#endif
}

long count_lines (istream& s)
{
  const int LineMax = 256;

  char line[LineMax];
  int i = 0;
  
  while (s.getline(line, LineMax)) i++;
  return i;
}

