// Copyright (C) 1997-1999  Adrian Trapletti
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

//
// Example of non-linear regression with ffnet
//


#include <fstream.h>
extern "C" {
#include "nrlinal.h"
}
#include "linal.hh"
#include "utils.hh"
#include "neuro.hh"


const long n = 1000;  // sample size
const int nhid = 2;  // number of hidden units


int main (int argc, char* argv[])  
{
  if (argc != 2)
  {
    cout << "Not the right number of arguments!" << endl;
    exit(1);
  }
  else 
  {
    long i;
    double errv;  // final objective function value
    estim_proc ep;  // estimation procedure object
    ofstream res_stream(argv[1]);  // write final results to res_stream
    mat x(n,1), y(n,1), e(n,1);  // inputs, targets, and errors
    mat res (n,3), ynet;  // results
    ffnet nn (x.columns(), nhid, y.columns(), SIG, LIN, TRUE);  // construct nn as ffnet
   
    x.rand (UNIFORM, -1.0, 1.0);  // inputs uniformly over (-1,1)
    e.rand (GAUSS, 0.0, 0.01);  // errors Gaussian N(0,0.01)
    y = x*x; 
    y += e;  // y = x*x+e
    ep.init (DFPMIN, 1, 200, 1.0e-6);  // set the estimation procedure to DFPMIN
    errv = nn.train (x, y, SSE, NOR, 0.0, ep);  // train nn on (x,y)
    ynet = nn.predict (x);  // compute the prediction of nn
    for (i=1; i<=n; i++)  // save inputs, targets, and predictions in res
    {
      res(i,1) = x(i,1);
      res(i,2) = y(i,1);
      res(i,3) = ynet(i,1);
    }
    res_stream << res;  // write the results
  }
}
    

