#include <stdio.h>
#include <stdlib.h>
#include "imem.h"

#ifdef MSS
#include "mss.h"
#endif

void *
my_malloc (size_t size, void *opaque)
{
  return malloc (size);
}

void *
my_calloc (size_t num, size_t size, void *opaque)
{
  return calloc (num, size);
}


void *
my_realloc (void *p, size_t size, void *opaque)
{
  return realloc (p, size);
}

void
my_free (void *p, void *opaque)
{
  free (p);
}


#ifdef NORMAL
#define MALLOC(n) malloc(n)
#define FREE(p)  free(p)
#define REALLOC(p, s) realloc(p,s)
#else
#define MALLOC(n) imem_malloc (&imem, n, __FILE__, __LINE__, "main")
#define FREE(p) imem_free (&imem, p, __FILE__, __LINE__, "main")
#define REALLOC(p, s) imem_realloc(&imem, p, s, __FILE__, __LINE__, "main")
#endif

#include <locale.h>

int
main (int argc, char **argv)
{
  int n, cycles = 0;
  size_t tsize = 0;
  imem_t imem;
  char *p = NULL;
  static const except_id_t catch[] =
  {
    {XCEPT_GROUP_ANY, XCEPT_CODE_ANY}};
  except_t *ex;
  struct except_params exc;
  struct except_params *ex_pars = &exc;
  imem_funcs_t mf;

	IMEM_INIT_FUNCS (&mf,
		IMEM_KEEP_AMB | IMEM_USE_POOL |	IMEM_THROW |
		IMEM_WITH_LOG | IMEM_WITH_ZB,	my_malloc, my_calloc,
		my_realloc, my_free, NULL);

  setlocale (LC_ALL, "C");

  if (argc < 3)
		{
			printf ("Usage: %s block-size seed\n", argv[0]);
			printf ("es: %s 3 123\n", argv[0]);
	    exit (EXIT_SUCCESS);
		}

  p = malloc (0);
  if (p != NULL)
    {
     fprintf (stderr, "malloc (0) doesn't return NULL (%p)\n", p);
     free (p);
    }

#ifndef MSS
  p = malloc (-1);
  if (p != NULL)
    {
     fprintf (stderr, "malloc (-1) doesn't return NULL (%p)\n", p);
     free (p);
    }
#endif

  imem_init (&imem, &mf, ex_pars,	IMEM_MAKE_LOG_NAME (timem));
	//imem_init_w32 (&imem);
	imem_set_random_fail (&imem, 0.01, atoi (argv[2]));
	//imem_random_test (&imem, 10000);

	/*
	 * explicit test of zero-sized blocks
	 */
	{
		char * ptr;
	  except_init (ex_pars);
	  except_try_push (catch, 1, &ex);
		ptr = MALLOC (0L);
		ptr = REALLOC (ptr, 0L);
		ptr = REALLOC (ptr, 1024L);
		ptr = REALLOC (ptr, 0L);
		ptr = REALLOC (ptr, 1024L);
		ptr = REALLOC (ptr, 512L);
		ptr = REALLOC (ptr, 1024L);
		ptr = REALLOC (ptr, 0L);
		FREE (ptr);
	  except_try_pop ();
	}

joke:
  cycles++;
  except_init (ex_pars);
  except_try_push (catch, 1, &ex);

  if (ex == NULL)
    {
      imem_set_mem_space (&imem, cycles);

      tsize = 0;
      for (n = 0;;)
        {
          int size = (int)((double) rand () / RAND_MAX * atoi (argv[1]));
				  if (n > 534)
            p = MALLOC (1000000000);
          p = MALLOC (size);
          p = REALLOC(p, size * 2);

					if (p == NULL && !(mf.flags & IMEM_KEEP_AMB))
						{
							fputs ("\nForcing loop exiting\n", stderr);
							goto EXIT_LOOP;
						}

          tsize += size * 2;
					n++;
          fprintf (stderr, "\rn: %d, size: %d", n, size);
        }
    }

  fprintf (stderr, "\n");

  if (ex != NULL)
    {
			imem_log_info (&imem);
      fprintf (stderr, "[%d block(s)] exception caught: %s !\n", n, except_message (ex));
EXIT_LOOP:
			if (mf.flags & IMEM_KEEP_AMB)
				imem_free_mem_space (&imem, cycles);
    }
  except_try_pop ();
  if (cycles <= 5)
    goto joke;

	if (mf.flags & IMEM_KEEP_AMB)
	  imem_free_mem_space (&imem, 0);

  imem_set_mem_space (&imem, 0);
  imem_deinit (&imem, 0);

  return 0;
}
