#include "iuser.h"

static char_t *rcsid = "$Id: error.c 1.2 2000-08-25 18:31:31+02 fede Exp fede $";

/*
 * TODO:
 *
 * - use of DISPATCH_DUMP ?
 *
 * $Log: error.c $
 * Revision 1.2  2000-08-25 18:31:31+02  fede
 * Implemented iuser_error_init.
 * Added iuser_error_format_severity
 *
 * Revision 1.1  2000-08-23 18:06:17+02  fede
 * Removed predefined contexts.
 * Completed first implementtion.
 *
 *
 */

iuser_error_t _g_iuser_error;
iuser_error_t * const g_iuser_error = & _g_iuser_error;

char_t *
iuser_error_format_severity (iuser_error_t * ierror)
{
	const char_t * const sev [] =
	{ AS_TEXT("None"),
	AS_TEXT("Information") /* IUSER_SEVERITY_INFO    = 1 */,
	AS_TEXT("Warning") /* IUSER_SEVERITY_WARN    = 2 */,
	AS_TEXT("Severe") /* IUSER_SEVERITY_SEVERE  = 3 */,
	AS_TEXT("Fatal") /* IUSER_SEVERITY_FATAL   = 4 */};

	assert (ierror->_severity < sizeof (sev));
	return sev[ierror->_severity];
}

int
iuser_error_init (iuser_error_t * ierror, char_t * name,
	iuser_error_context_t * ctx, iuser_error_callback_t cb, void * opaque)
{
	assert (ierror != NULL);
	assert (cb != NULL);
	assert (ctx != NULL);

	memset (ierror, 0, sizeof (iuser_error_t));

	ierror->_opaque = opaque;
	ierror->_name = name;

	memcpy (&ierror->_context, ctx, sizeof (iuser_error_context_t));

	if (cb (ierror, IUSER_ERROR_INIT) == IUSER_OK)
		{
			ierror->_cb = cb;
			ierror->_flags |= IUSER_ERROR_IS_INITIALIZED;
			return IUSER_OK;
		}

	memset (ierror, 0, sizeof (iuser_error_t));

	return IUSER_ERROR;
}

void
iuser_error_deinit (iuser_error_t * ierror)
{
	assert (ierror != NULL);

	ierror->_cb (ierror, IUSER_ERROR_DEINIT);
	ierror->_flags |= IUSER_ERROR_IS_DEINITIALIZED;
}

void
iuser_error_clear (iuser_error_t * ierror)
{
	assert (ierror != NULL);
	ierror->_code = 0;
	ierror->_severity = IUSER_SEVERITY_NONE;
	ierror->_msg.text = NULL;
}

/* Used to arbitrate */
iuser_error_context_t *
iuser_error_set_context (iuser_error_t * ierror, iuser_error_context_t * ctx)
{
	iuser_error_context_t * prev_ctx;

	assert (ierror != NULL);

	prev_ctx = &ierror->_context;

	if (ctx != NULL)
		memcpy (&ierror->_context, ctx, sizeof (iuser_error_context_t));

	return prev_ctx;
}

iuser_error_context_t *
iuser_error_get_context (iuser_error_t * ierror)
{
	assert (ierror != NULL);
	return iuser_error_set_context (ierror, NULL);
}

iuser_error_callback_t
iuser_error_set_callback (iuser_error_t * ierror, iuser_error_callback_t cb)
{
	iuser_error_callback_t prev_cb;
	assert (ierror != NULL);

	prev_cb = ierror->_cb;

	if (cb != NULL)
		ierror->_cb = cb;

	return prev_cb;
}

iuser_error_callback_t
iuser_error_get_callback (iuser_error_t * ierror)
{
	assert (ierror != NULL);
	return iuser_error_set_callback (ierror, NULL);
}

void *
iuser_error_set_opaque (iuser_error_t * ierror, void * opaque)
{
	void * prev_opaque;

	assert (ierror != NULL);
	prev_opaque = ierror->_opaque;

	if (opaque != NULL)
		ierror->_opaque = opaque;

	return prev_opaque;
}

void *
iuser_error_get_opaque (iuser_error_t * ierror)
{
	assert (ierror != NULL);
	return iuser_error_set_opaque (ierror, NULL);
}

char_t *
iuser_error_get_message (iuser_error_t * ierror)
{
	assert (ierror != NULL);

	return ierror->_msg.text;
}

char *
iuser_error_get_file (iuser_error_t * ierror)
{
	assert (ierror != NULL);

	return ierror->_file;
}

size_t
iuser_error_get_line (iuser_error_t * ierror)
{
	assert (ierror != NULL);

	return ierror->_line;
}

char_t *
iuser_error_get_name (iuser_error_t * ierror)
{
	assert (ierror != NULL);

	return ierror->_name;
}

