% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_ph.R
\name{compute_ph_y_mctq_chrono}
\alias{compute_ph_y_mctq_chrono}
\title{Compute "Munich Chronotype Questionnaire [Youth] (Chronotype): Time"}
\usage{
compute_ph_y_mctq_chrono(data, name = "ph_y_mctq_chrono", combine = TRUE)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the new column to be created (Default:
the name used in the ABCD data release).}

\item{combine}{logical. If TRUE, the new column will be bound to the input
data frame. If FALSE, the new column will be created as a new data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{ph_y_mctq_chrono}
Munich Chronotype Questionnaire [Youth] (Chronotype): Time
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{ph_y_mctq__fd_007}
\item \code{ph_y_mctq__fd__sleep_dur} (intermediate score)
\item \code{ph_y_mctq__sd__sleep_dur} (intermediate score)
\item \code{ph_y_mctq__fd__sleep__mid__36h_t} (intermediate score)
\item \code{ph_y_mctq__fd__sleep__onset__36h_t} (intermediate score)
\item \code{ph_y_mctq__sleep_dur} (intermediate score)
}
\item \emph{Excluded values:} none
}
}
\examples{
\dontrun{
compute_ph_y_mctq_chrono(data) |>
  select(
    any_of(c(
      "ph_y_mctq_chrono"
    ))
  )
}
}
