% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Contact.R
\name{newConfigurationModel}
\alias{newConfigurationModel}
\title{Creates a random network using the configuration model}
\arguments{
\item{rng}{a function that generates random degrees}
}
\value{
an external pointer.
}
\description{
Creates a random network using the configuration model
}
\details{
The population must be an external pointer, not an R6 object
To use an R6 object, we should use its pointer representation from its
$get method.

The function rng should take exactly one argument n for the number of degrees
to generate, and should return an integer vector of length n.
}
\examples{
# creates a simulation with 100 agents
sim = Simulation$new(100)
# add a Poisson network with a mean degree 5
sim$addContact(newConfigurationModel(function(n) rpois(n, 5)))

}
