% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLoops.R
\name{testAllSigMatrices}
\alias{testAllSigMatrices}
\title{Generate all the signature matrices one time with the option to leave out half of the data as a test set}
\usage{
testAllSigMatrices(
  exprData,
  randomize = TRUE,
  skipShrink = FALSE,
  proportional = FALSE,
  handMetaCluster = NULL,
  testOnHalf = TRUE
)
}
\arguments{
\item{exprData}{The gene express data. Each row is a gene, and each column is an example of a particular cell type.}

\item{randomize}{Set to to TRUE randomize the sets selected by ADAPTS::scSample (DEFAULT: TRUE)}

\item{skipShrink}{Set to TRUE to skip shrinking the signatrure matrix (DEFAULT: TRUE)}

\item{proportional}{Set to true to make the training set cell type proportional.  Ignores group size (DEFAULT: FALSE)}

\item{handMetaCluster}{A List of pre-defined meta clusters.Set to NULL to automatically group indistinguishable cells 
into same cluster using clustWspillOver.(DEFAULT: NULL)}

\item{testOnHalf}{Set to TRUE to leave half the data as a test set}
}
\value{
A list of results including prediction accuracy and cell enrichment
}
\description{
This wrapper is helpful for repetitively matrix generation. It generates seed matrix, all-gene matrix, augmented matrix, shrunk matrix,
and all the clustered matrices in one call.
}
\examples{
ct1 <- runif(1000, 0, 100)
ct2 <- runif(1000, 0, 100)
ct3 <- runif(1000, 0, 100)
ct4 <- runif(1000, 0, 100)
dataMat <- cbind(ct1, ct1, ct1, ct1, ct1, ct1, ct2, ct2, ct2, ct2, ct3, ct3, ct3,ct3,ct4,ct4)
rownames(dataMat) <- make.names(rep('gene', nrow(dataMat)), unique=TRUE)
noise <- matrix(runif(nrow(dataMat)*ncol(dataMat), -2, 2), nrow = nrow(dataMat), byrow = TRUE)
dataMat <- dataMat + noise
metaList <- list()
colnames(dataMat) <- sub('\\\\..*','', colnames(dataMat))
metaList[[1]] <- c(unique(colnames(dataMat))[1])  #Cell Type 1
metaList[[2]] <- c(unique(colnames(dataMat))[2])  #Cell Type 2
metaList[[3]] <- c(unique(colnames(dataMat))[3])  #Cell Type 3
metaList[[4]] <- c(unique(colnames(dataMat))[4:length(unique(colnames(dataMat)))])  #Cell Type 4
#options(mc.cores=2)
#  This is a meta-function that calls other functions, 
#  The execution speed is too slow for the CRAN automated check
#testAllSigMatrices(exprData=dataMat, randomize = TRUE, skipShrink=FALSE, 
#    proportional=FALSE, handMetaCluster=metaList,testOnHalf=TRUE)
}
