% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hmatrix.R
\name{Hmatrix}
\alias{Hmatrix}
\title{Construction of Combined Relationship Matrix H}
\usage{
Hmatrix(
  A = NULL,
  G = NULL,
  markers = NULL,
  c = 0,
  method = "Martini",
  tau = 1,
  omega = 1,
  missingValue = -9,
  maf = 0,
  ploidy = 2,
  roundVar = 3
)
}
\arguments{
\item{A}{A matrix from function Amatrix}

\item{G}{G matrix from function Gmatrix}

\item{markers}{matrix marker which generated the Gmatrix}

\item{c}{constant value of H computation, default: c=0}

\item{method}{"Martini" or "Munoz", default="Martini"}

\item{tau}{to be used for Martini's method, default=1.}

\item{omega}{to be used of Martini's method, default=1.}

\item{missingValue}{missing value in data, default=-9.}

\item{maf}{max of missing data accepted to each markerm default=0.05.}

\item{ploidy}{data ploidy (an even number between 2 and 20), default=2.}

\item{roundVar}{only used for Munoz's method, how many digits to consider the relationship be of same class, default=2.}
}
\value{
H Matrix with the relationship between the individuals based on pedigree and corrected by molecular information
}
\description{
Given a matrix A and a matrix G returns a H matrix. H matrix is the relationship matrix using combined information from the pedigree and genomic relationship matrices. First, you need to compute the matrices separated and then use them as input to build the combined H matrix. 
Two methods are implemented: `Munoz` shrinks the G matrix towards the A matrix scaling the molecular relatadness by each relationship classes; 
`Martini` is a modified version from Legarra et al. (2009) where combines A and G matrix using scaling factors. When method is equal `Martini` and `tau=1` and `omega=1` you have the same H matrix as in Legarra et al. (2009).
}
\examples{
\dontrun{
data(ped.sol)
data(snp.sol)
#Computing the numerator relationship matrix 10\% of double-reduction
Amat <- Amatrix(ped.sol, ploidy=4, w = 0.1)
#Computing the additive relationship matrix based on VanRaden (modified)
Gmat <- Gmatrix(snp.sol, ploidy=4, 
                maf=0.05, method="VanRaden")
Gmat <- round(Gmat,3) #to be easy to invert

#Computing H matrix (Martini)
Hmat_Martini <- Hmatrix(A=Amat, G=Gmat, method="Martini", 
                     ploidy=4, 
                     maf=0.05)
                     
#Computing H matrix (Munoz)
Hmat_Munoz <- Hmatrix(A=Amat, G=Gmat, markers = snp.sol, 
                      ploidy=4, method="Munoz",
                      roundVar=2,
                      maf=0.05)
}

}
\references{
\emph{Munoz, PR. 2014 Unraveling additive from nonadditive effects using genomic relationship matrices. Genetics 198, 1759-1768}

\emph{Martini, JW, et al. 2018 The effect of the H-1 scaling factors tau and omega on the structure of H in the single-step procedure. Genetics Selection Evolution 50(1), 16}

\emph{Legarra, A, et al. 2009 A relationship matrix including full pedigree and genomic information. Journal of Dairy Science 92, 4656–4663}
}
\author{
Rodrigo R Amadeu, \email{rramadeu@gmail.com}
}
