% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHPtools.R
\name{createLogicalPCM}
\alias{createLogicalPCM}
\title{Simulated Logical Pairwise Comparison Matrix for the
Analytic Hierarchy Process}
\usage{
createLogicalPCM(ord, prefVec = rep(NA, ord), granularityLow = TRUE)
}
\arguments{
\item{ord}{The desired order of the Pairwise Comparison Matrix}

\item{prefVec}{The preference vector of length as the order of the
input matrix}

\item{granularityLow}{The Scale for pairwise comparisons; default (TRUE)
is the fundamental scale; else uses a more find grained scale, derived
from pairwise ratios of the elements of the Fundamental Scale.}
}
\value{
A Logical Pairwise Comparison Matrix
}
\description{
Creates a logical pairwise comparison matrix for the Analytic
Hierarchy Process such as would be created by a rational decision maker
based on a relative vector of preferences for the alternatives involved.
Choices of the pairwise comparison ratios are from the Fundamental Scale
and simulate a reasonable degree of error. The algorithm is modified from
a paper by Bose, A [2022], \doi{https://doi.org/10.1002/mcda.1784}
}
\examples{
lPCM <- createLogicalPCM(3,c(1,2,3));
lPCM <- createLogicalPCM(5,c(0.25,0.4,0.1,0.05,0.2));
}
