% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/Getters.R
\docType{methods}
\name{getMinCorner}
\alias{getMinCorner}
\alias{getMinCorner,VoxelSpace-method}
\title{Gets the x, y, z coordinates of the voxel space bottom left corner.}
\usage{
getMinCorner(vxsp)

\S4method{getMinCorner}{VoxelSpace}(vxsp)
}
\arguments{
\item{vxsp}{the \code{\linkS4class{VoxelSpace}} object.}
}
\value{
the x, y, z coordinates of the voxel space bottom left corner, as a
numerical vector.
}
\description{
Gets the x, y, z coordinates of the voxel space bottom left
corner.
}
\examples{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
# retrieve 'min_corner' parameter
getMinCorner(vxsp)
}
