\name{genDXX}
\alias{genDtf1d}
\alias{genDtf2d}
\alias{genD2d}
\title{Generate D Matrix}
\description{
  Generate D matrix which is used to do polynomial trend filtering of order k
}
\usage{
genDtf1d(k,n=NULL,full=FALSE)
genDtf2d(k,dim1=NULL,dim2=NULL,full=FALSE)
genD2d(dim1=NULL,dim2=NULL,full=FALSE)
}
\arguments{
  \item{k}{The order of polynomial trend filtering.}
  \item{n}{Length of observe sequence y for genDtf1d, only be used in the \code{full} mode.}
  \item{dim1}{The number of rows for genDtf2d, only be used in the \code{full} mode.}
  \item{dim2}{The number of columns for genDtf2d, only be used in the \code{full} mode.}
  \item{full}{Whether to return the full matrix, if TRUE, it gennerate a full matrix.}
}
\details{
  In 1d case, D is used to do polynomial trend filtering of order k, and 
  generated by \deqn{D_{tf,k} = D1d * D_{tf,k-1}  for  k >= 2,} where the nozero 
  elements in each row is \code{(1,-2,1)} in D_{tf,1} and \code{(-1,1)} in D_{1d}. 
  This is usually not necessary to call directly, as \code{AMIAS} internally 
  gennerate D, but inspection of the matrix can sometimes be useful.
}
\value{
  \item{vecctor}{Vector: return when full is FALSE, nozero elements in first row(equal to any other row) of D.}
  \item{matrix}{Matrix: return when full is TRUE, whole sparse D.}
}

\author{
  Canhong Wen, Xueqin Wang, Shijie Quan, Zelin Hong and Aijun Zhang.
  
  Maintainer: Canhong Wen <wench@ustc.edu.cn>
}
\references{
  Wen, C., Zhu, J., Wang, X., and Zhang, A. (2019) \emph{L0 trend filtering}, technique report.
}


\examples{

  genDtf1d(k = 2)
  genDtf1d(k = 1, n = 10, full = TRUE)
}
