% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ablist}
\alias{ablist}
\title{Dataset with 420 antibiotics}
\format{A data.frame with 420 observations and 12 variables:
\describe{
  \item{\code{atc}}{ATC code, like \code{J01CR02}}
  \item{\code{molis}}{MOLIS code, like \code{amcl}}
  \item{\code{umcg}}{UMCG code, like \code{AMCL}}
  \item{\code{official}}{Official name by the WHO, like \code{"amoxicillin and enzyme inhibitor"}}
  \item{\code{official_nl}}{Official name in the Netherlands, like \code{"Amoxicilline met enzymremmer"}}
  \item{\code{trivial_nl}}{Trivial name in Dutch, like \code{"Amoxicilline/clavulaanzuur"}}
  \item{\code{oral_ddd}}{Defined Daily Dose (DDD) according to the WHO, oral treatment}
  \item{\code{oral_units}}{Units of \code{ddd_units}}
  \item{\code{iv_ddd}}{Defined Daily Dose (DDD) according to the WHO, parenteral treatment}
  \item{\code{iv_units}}{Units of \code{iv_ddd}}
  \item{\code{atc_group1}}{ATC group in Dutch, like \code{"Macroliden, lincosamiden en streptograminen"}}
  \item{\code{atc_group2}}{Subgroup of \code{atc_group1} in Dutch, like \code{"Macroliden"}}
}}
\source{
MOLIS (LIS of Certe) - \url{https://www.certe.nl} \cr \cr GLIMS (LIS of UMCG) - \url{https://www.umcg.nl} \cr \cr World Health Organization - \url{https://www.whocc.no/atc_ddd_index/}
}
\usage{
ablist
}
\description{
A dataset containing all antibiotics with a J0 code, with their DDD's.
}
\seealso{
\code{\link{bactlist}}
}
\keyword{datasets}
