% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{like}
\alias{like}
\alias{\%like\%}
\title{Pattern Matching}
\source{
Inherited from the \href{https://github.com/Rdatatable/data.table/blob/master/R/like.R}{\code{like} function from the \code{data.table} package}, but made it case insensitive at default.
}
\usage{
x \%like\% pattern
}
\arguments{
\item{x}{a character vector where matches are sought, or an
    object which can be coerced by \code{as.character} to a character
    vector.  \link{Long vectors} are supported.}

\item{pattern}{character string containing a \link{regular expression}
    (or character string for \code{fixed = TRUE}) to be matched
    in the given character vector.  Coerced by
    \code{\link{as.character}} to a character string if possible.  If a
    character vector of length 2 or more is supplied, the first element
    is used with a warning.  Missing values are allowed except for
    \code{regexpr} and \code{gregexpr}.}
}
\value{
A \code{logical} vector
}
\description{
Convenience function to compare a vector with a pattern, like \code{\link[base]{grep}}. It always returns a \code{logical} vector and is always case-insensitive.
}
\examples{
library(dplyr)
# get unique occurences of bacteria whose name start with 'Ent'
septic_patients \%>\%
  left_join_microorganisms() \%>\%
  filter(fullname \%like\% '^Ent') \%>\%
  pull(fullname) \%>\%
  unique()
}
