% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eucast_rules.R
\name{eucast_rules}
\alias{eucast_rules}
\alias{EUCAST_rules}
\alias{interpretive_reading}
\title{EUCAST rules}
\source{
\itemize{
    \item{
      EUCAST Expert Rules. Version 2.0, 2012. \cr
      Leclercq et al. \strong{EUCAST expert rules in antimicrobial susceptibility testing.} \emph{Clin Microbiol Infect.} 2013;19(2):141-60. \cr
      \url{https://doi.org/10.1111/j.1469-0691.2011.03703.x}
    }
    \item{
      EUCAST Expert Rules, Intrinsic Resistance and Exceptional Phenotypes Tables. Version 3.1, 2016.  \cr
      \url{http://www.eucast.org/fileadmin/src/media/PDFs/EUCAST_files/Expert_Rules/Expert_rules_intrinsic_exceptional_V3.1.pdf}
    }
    \item{
      EUCAST Breakpoint tables for interpretation of MICs and zone diameters. Version 8.1, 2018. \cr
      \url{http://www.eucast.org/fileadmin/src/media/PDFs/EUCAST_files/Breakpoint_tables/v_8.1_Breakpoint_Tables.xlsx}
    }
  }
}
\usage{
eucast_rules(tbl, col_mo = NULL, info = TRUE,
  rules = c("breakpoints", "expert", "other", "all"), verbose = FALSE,
  amcl = "amcl", amik = "amik", amox = "amox", ampi = "ampi",
  azit = "azit", azlo = "azlo", aztr = "aztr", cefa = "cefa",
  cfep = "cfep", cfot = "cfot", cfox = "cfox", cfra = "cfra",
  cfta = "cfta", cftr = "cftr", cfur = "cfur", chlo = "chlo",
  cipr = "cipr", clar = "clar", clin = "clin", clox = "clox",
  coli = "coli", czol = "czol", dapt = "dapt", doxy = "doxy",
  erta = "erta", eryt = "eryt", fosf = "fosf", fusi = "fusi",
  gent = "gent", imip = "imip", kana = "kana", levo = "levo",
  linc = "linc", line = "line", mero = "mero", mezl = "mezl",
  mino = "mino", moxi = "moxi", nali = "nali", neom = "neom",
  neti = "neti", nitr = "nitr", norf = "norf", novo = "novo",
  oflo = "oflo", oxac = "oxac", peni = "peni", pipe = "pipe",
  pita = "pita", poly = "poly", pris = "pris", qida = "qida",
  rifa = "rifa", roxi = "roxi", siso = "siso", teic = "teic",
  tetr = "tetr", tica = "tica", tige = "tige", tobr = "tobr",
  trim = "trim", trsu = "trsu", vanc = "vanc", col_bactid = NULL)

EUCAST_rules(...)

interpretive_reading(...)
}
\arguments{
\item{tbl}{table with antibiotic columns, like e.g. \code{amox} and \code{amcl}}

\item{col_mo}{column name of the unique IDs of the microorganisms (see \code{\link{mo}}), defaults to the first column of class \code{mo}. Values will be coerced using \code{\link{as.mo}}.}

\item{info}{print progress}

\item{rules}{a character vector that specifies which rules should be applied - one or more of \code{c("breakpoints", "expert", "other", "all")}}

\item{verbose}{a logical to indicate whether extensive info should be returned as a \code{data.frame} with info about which rows and columns are effected}

\item{amcl, amik, amox, ampi, azit, azlo, aztr, cefa, cfep, cfot, cfox, cfra, cfta, cftr, cfur, chlo, cipr, clar, clin, clox, coli, czol, dapt, doxy, erta, eryt, fosf, fusi, gent, imip, kana, levo, linc, line, mero, mezl, mino, moxi, nali, neom, neti, nitr, norf, novo, oflo, oxac, peni, pipe, pita, poly, pris, qida, rifa, roxi, siso, teic, tetr, tica, tige, tobr, trim, trsu, vanc}{column name of an antibiotic, see Details}

\item{col_bactid}{deprecated, use \code{col_mo} instead.}

\item{...}{parameters that are passed on to \code{eucast_rules}}
}
\value{
The input of \code{tbl}, possibly with edited values of antibiotics. Or, if \code{verbose = TRUE}, a \code{data.frame} with verbose info.
}
\description{
Apply susceptibility rules as defined by the European Committee on Antimicrobial Susceptibility Testing (EUCAST, \url{http://eucast.org}), see \emph{Source}. This includes (1) expert rules, (2) intrinsic resistance and (3) inferred resistance as defined in their breakpoint tables.
}
\details{
To define antibiotics column names, input a text or use \code{NA} to skip a column (e.g. \code{tica = NA}). Non-existing columns will anyway be skipped with a warning. See the Antibiotics section for an explanation of the abbreviations.
}
\section{Antibiotics}{

Abbrevations of the column containing antibiotics in the form: \strong{abbreviation}: generic name (\emph{ATC code})

 \strong{amcl}: amoxicillin+clavulanic acid (\emph{J01CR02}),
 \strong{amik}: amikacin (\emph{J01GB06}),
 \strong{amox}: amoxicillin (\emph{J01CA04}),
 \strong{ampi}: ampicillin (\emph{J01CA01}),
 \strong{azit}: azithromycin (\emph{J01FA10}),
 \strong{azlo}: azlocillin (\emph{J01CA09}),
 \strong{aztr}: aztreonam (\emph{J01DF01}),
 \strong{cefa}: cefaloridine (\emph{J01DB02}),
 \strong{cfep}: cefepime (\emph{J01DE01}),
 \strong{cfot}: cefotaxime (\emph{J01DD01}),
 \strong{cfox}: cefoxitin (\emph{J01DC01}),
 \strong{cfra}: cefradine (\emph{J01DB09}),
 \strong{cfta}: ceftazidime (\emph{J01DD02}),
 \strong{cftr}: ceftriaxone (\emph{J01DD04}),
 \strong{cfur}: cefuroxime (\emph{J01DC02}),
 \strong{chlo}: chloramphenicol (\emph{J01BA01}),
 \strong{cipr}: ciprofloxacin (\emph{J01MA02}),
 \strong{clar}: clarithromycin (\emph{J01FA09}),
 \strong{clin}: clindamycin (\emph{J01FF01}),
 \strong{clox}: flucloxacillin (\emph{J01CF05}),
 \strong{coli}: colistin (\emph{J01XB01}),
 \strong{czol}: cefazolin (\emph{J01DB04}),
 \strong{dapt}: daptomycin (\emph{J01XX09}),
 \strong{doxy}: doxycycline (\emph{J01AA02}),
 \strong{erta}: ertapenem (\emph{J01DH03}),
 \strong{eryt}: erythromycin (\emph{J01FA01}),
 \strong{fosf}: fosfomycin (\emph{J01XX01}),
 \strong{fusi}: fusidic acid (\emph{J01XC01}),
 \strong{gent}: gentamicin (\emph{J01GB03}),
 \strong{imip}: imipenem (\emph{J01DH51}),
 \strong{kana}: kanamycin (\emph{J01GB04}),
 \strong{levo}: levofloxacin (\emph{J01MA12}),
 \strong{linc}: lincomycin (\emph{J01FF02}),
 \strong{line}: linezolid (\emph{J01XX08}),
 \strong{mero}: meropenem (\emph{J01DH02}),
 \strong{mezl}: mezlocillin (\emph{J01CA10}),
 \strong{mino}: minocycline (\emph{J01AA08}),
 \strong{moxi}: moxifloxacin (\emph{J01MA14}),
 \strong{nali}: nalidixic acid (\emph{J01MB02}),
 \strong{neom}: neomycin (\emph{J01GB05}),
 \strong{neti}: netilmicin (\emph{J01GB07}),
 \strong{nitr}: nitrofurantoin (\emph{J01XE01}),
 \strong{norf}: norfloxacin (\emph{J01MA06}),
 \strong{novo}: novobiocin (an ATCvet code: \emph{QJ01XX95}),
 \strong{oflo}: ofloxacin (\emph{J01MA01}),
 \strong{peni}: penicillin (\emph{J01RA01}),
 \strong{pipe}: piperacillin (\emph{J01CA12}),
 \strong{pita}: piperacillin+tazobactam (\emph{J01CR05}),
 \strong{poly}: polymyxin B (\emph{J01XB02}),
 \strong{pris}: pristinamycin (\emph{J01FG01}),
 \strong{qida}: quinupristin/dalfopristin (\emph{J01FG02}),
 \strong{rifa}: rifampicin (\emph{J04AB02}),
 \strong{roxi}: roxithromycin (\emph{J01FA06}),
 \strong{siso}: sisomicin (\emph{J01GB08}),
 \strong{teic}: teicoplanin (\emph{J01XA02}),
 \strong{tetr}: tetracycline (\emph{J01AA07}),
 \strong{tica}: ticarcillin (\emph{J01CA13}),
 \strong{tige}: tigecycline (\emph{J01AA12}),
 \strong{tobr}: tobramycin (\emph{J01GB01}),
 \strong{trim}: trimethoprim (\emph{J01EA01}),
 \strong{trsu}: sulfamethoxazole and trimethoprim (\emph{J01EE01}),
 \strong{vanc}: vancomycin (\emph{J01XA01}).
}

\examples{
a <- eucast_rules(septic_patients)

a <- data.frame(mo = c("Staphylococcus aureus",
                       "Enterococcus faecalis",
                       "Escherichia coli",
                       "Klebsiella pneumoniae",
                       "Pseudomonas aeruginosa"),
                vanc = "-",       # Vancomycin
                amox = "-",       # Amoxicillin
                coli = "-",       # Colistin
                cfta = "-",       # Ceftazidime
                cfur = "-",       # Cefuroxime
                peni = "S",       # Benzylpenicillin
                cfox = "S",       # Cefoxitin
                stringsAsFactors = FALSE)

a
#                       mo vanc amox coli cfta cfur peni cfox
# 1  Staphylococcus aureus    -    -    -    -    -    S    S
# 2  Enterococcus faecalis    -    -    -    -    -    S    S
# 3       Escherichia coli    -    -    -    -    -    S    S
# 4  Klebsiella pneumoniae    -    -    -    -    -    S    S
# 5 Pseudomonas aeruginosa    -    -    -    -    -    S    S

b <- eucast_rules(a, "mo") # 18 results are forced as R or S

b
#                       mo vanc amox coli cfta cfur peni cfox
# 1  Staphylococcus aureus    -    S    R    R    S    S    S
# 2  Enterococcus faecalis    -    -    R    R    R    S    R
# 3       Escherichia coli    R    -    -    -    -    R    S
# 4  Klebsiella pneumoniae    R    R    -    -    -    R    S
# 5 Pseudomonas aeruginosa    R    R    -    -    R    R    R
}
\keyword{eucast}
\keyword{interpretive}
\keyword{reading}
\keyword{resistance}
