% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{microorganisms.groups}
\alias{microorganisms.groups}
\title{Data Set with 521 Microorganisms In Species Groups}
\format{
A \link[tibble:tibble]{tibble} with 521 observations and 4 variables:
\itemize{
\item \code{mo_group}\cr ID of the species group / microbiological complex
\item \code{mo}\cr ID of the microorganism belonging in the species group / microbiological complex
\item \code{mo_group_name}\cr Name of the species group / microbiological complex, as retrieved with \code{\link[=mo_name]{mo_name()}}
\item \code{mo_name}\cr Name of the microorganism belonging in the species group / microbiological complex, as retrieved with \code{\link[=mo_name]{mo_name()}}
}
}
\usage{
microorganisms.groups
}
\description{
A data set containing species groups and microbiological complexes, which are used in \link[=clinical_breakpoints]{the clinical breakpoints table}.
}
\details{
Like all data sets in this package, this data set is publicly available for download in the following formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, SAS, and Stata. Please visit \href{https://msberends.github.io/AMR/articles/datasets.html}{our website for the download links}. The actual files are of course available on \href{https://github.com/msberends/AMR/tree/main/data-raw}{our GitHub repository}.
}
\examples{
microorganisms.groups

# these are all species in the Bacteroides fragilis group, as per WHONET:
microorganisms.groups[microorganisms.groups$mo_group == "B_BCTRD_FRGL-C", ]
}
\seealso{
\code{\link[=as.mo]{as.mo()}} \link{microorganisms}
}
\keyword{datasets}
