% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siegel.tukey.R
\name{siegel.tukey}
\alias{siegel.tukey}
\title{Perform Siegel-Tukey test}
\usage{
siegel.tukey(
  x,
  y,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  mean.shift = FALSE,
  cont.corr = TRUE,
  max.exact.cases = 1000,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{mean.shift}{Boolean indicating whether mean shift to be used instead of median shift (defaults to \code{FALSE})}

\item{cont.corr}{Boolean indicating whether or not to use continuity correction (defaults to \code{TRUE})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{1000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{siegel.tukey()} performs the Siegel-Tukey test using mean or median shift and is used in chapter 6 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Exercise 6.11 from "Applied Nonparametric Statistical Methods" (5th edition)
siegel.tukey(ch6$typeA, ch6$typeB, mean.shift = TRUE)

# Exercise 6.16 from "Applied Nonparametric Statistical Methods" (5th edition)
siegel.tukey(ch6$travel, ch6$politics)

}
