% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vizAPOTC.R
\name{vizAPOTC}
\alias{vizAPOTC}
\title{Directly visualize clonal expansion of a combined seurat object}
\usage{
vizAPOTC(
  seurat_obj,
  reduction_base = "umap",
  clonecall = "strict",
  ...,
  extra_filter = NULL,
  clone_scale_factor = "auto",
  rad_scale_factor = 0.95,
  order_clones = TRUE,
  try_place = FALSE,
  repulse = TRUE,
  repulsion_threshold = 1,
  repulsion_strength = 1,
  max_repulsion_iter = 20L,
  res = 360L,
  linetype = "blank",
  use_default_theme = TRUE,
  retain_axis_scales = FALSE,
  show_labels = FALSE,
  label_size = 5,
  add_size_legend = TRUE,
  legend_sizes = "auto",
  legend_position = "auto",
  legend_buffer = 0.2,
  legend_color = "#808080",
  legend_spacing = "auto",
  legend_label = "Clone sizes",
  legend_text_size = 5,
  add_legend_background = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{seurat_obj}{Seurat object with one or more dimension reductions and
already have been integrated with a TCR/BCR library with
\code{scRepertoire::combineExpression}.}

\item{reduction_base}{character. The seurat reduction to base the clonal
expansion plotting on. Defaults to \code{'umap'} but can be any reduction present
within the reductions slot of the input seurat object, including custom ones.
If `'pca'``, the cluster coordinates will be based on PC1 and PC2.
However, generally APackOfTheClones is used for displaying UMAP and
occasionally t-SNE versions to intuitively highlight clonal expansion.}

\item{clonecall}{character. The column name in the seurat object metadata to
use. See \code{scRepertoire} documentation for more information about this
parameter that is central to both packages.}

\item{...}{additional "subsetting" keyword arguments indicating the rows
corresponding to elements in the seurat object metadata that should be
filtered by. E.g., \code{seurat_clusters = c(1, 9, 10)} will filter the cells to
those in the \code{seurat_clusters} column with any of the values 1, 9, and 10.
Unfortunately, column names in the seurat object metadata cannot
conflict with the keyword arguments. \emph{\strong{MAJOR NOTE}} if any subsetting
keyword arguments are a \emph{prefix} of any preceding argument names (e.g. a
column named \code{reduction} is a prefix of the \code{reduction_base} argument)
R will interpret it as the same argument unless \emph{both} arguments
are named. Additionally, this means any subsequent arguments \emph{must} be named.}

\item{extra_filter}{character. An additional string that should be formatted
\emph{exactly} like a statement one would pass into \link[dplyr:filter]{dplyr::filter} that does
\emph{additional} filtering to cells in the seurat object - on top of the other
keyword arguments - based on the metadata. This means that it will be
logically AND'ed with any keyword argument filters. This is a more flexible
alternative / addition to the filtering keyword arguments. For example, if
one wanted to filter by the length of the amino acid sequence of TCRs, one
could pass in something like \code{extra_filter = "nchar(CTaa) - 1 > 10"}. When
involving characters, ensure to enclose with single quotes.}

\item{clone_scale_factor}{Dictates how much to scale each circle(between 0,1)
radius when converting from clonotype counts into circles that represent
individual clonotypes. The argument defaults to the character \code{"auto"}, and
if so, the most visually pleasing factor will be estimated.}

\item{rad_scale_factor}{numeric between 0 and 1. This value decreases the
radius of the smallest clones by this scale factor. And the absolute value
of this decrease will be applied to all packed circles, effectively shrinking
all circles on the spot, and introduce more constant spacing in between.}

\item{order_clones}{logical. Decides if the largest clone circles should be
near cluster centroids. This is highly recommended to be set to TRUE for
increased intuitiveness of the visualization, as resulting plots tend to
give an improved impression of the proportion of expanded clones. If
\verb{FALSE,} will randomly scramble the positions of each circle. For the sake
of being replicable, a random seed is recommended to be set with \link{set.seed}.}

\item{try_place}{If \code{TRUE}, always minimizes distance from a newly placed
circle to the origin in the circle packing algorithm.}

\item{repulse}{If \code{TRUE}, will attempt to push overlapping clusters away from
each other.}

\item{repulsion_threshold}{numeric. The radius that clonal circle clusters
overlap is acceptable when repulsing.}

\item{repulsion_strength}{numeric. The smaller the value the less the
clusters repulse each other per iteration, and vice versa.}

\item{max_repulsion_iter}{integer. The number of repulsion iterations.}

\item{res}{The number of points on the generated path per full circle. From
plot viewers, if circles seem slightly too pixelated, it is recommended to
first try to export the plot as an \code{.svg} before increasing \code{res} due to
increased plotting times from \link[ggforce:geom_circle]{ggforce::geom_circle}.}

\item{linetype}{The type of outline each circle should have. defaults to
\verb{"blank} meaning no outline. More information is in the function
documentation of \code{ggforce::geom_circle}.}

\item{use_default_theme}{logical that defaults to \code{TRUE}. If \code{TRUE},
the resulting plot will have the same theme as the seurat reference reduction
plot. Else, the plot will simply have a blank background.}

\item{retain_axis_scales}{If \code{TRUE}, approximately maintains the axis scales
of the original reduction plot. However, it will only attempt to extend the
axes and never shorten. This is recommended to be set to \code{TRUE} especially if
working with subsetted versions of the clonal data.}

\item{show_labels}{If \code{TRUE}, will label each circle cluster at the centroid,
defaulting to "C0, C1, ...".}

\item{label_size}{The text size of labels if shown. Defaults to 5.}

\item{add_size_legend}{If \code{TRUE}, adds a legend to the plot visualizing the
relative sizes of clones. Note that it is simply an overlay and not a real
ggplot2 legend.}

\item{legend_sizes}{numeric vector. Indicates the circle sizes to be
displayed on the legend, and will always be sorted from smallest to greatest.
Defaults to \code{"auto"} which estimate a reasonable range of sizes to display.}

\item{legend_position}{character or numeric. Can be set to either
\code{"top_left"}, \code{"top_right"}, \code{"bottom_left"}, \code{"bottom_right"} and places the
legend roughly in the corresponding position. Otherwise, can be a numeric
vector of length 2 indicating the x and y position of the \emph{topmost (smallest)
circle} of the legend.}

\item{legend_buffer}{numeric. Indicates how much to "push" the legend towards
the center of the plot from the selected corner. If negative, will push away}

\item{legend_color}{character. Indicates the hex color of the circles
displayed on the legend. Defaults to the hex code for a gray tone}

\item{legend_spacing}{numeric. Indicates the horizontal distance between each
stacked circle on the size legend. Defaults to \code{"auto"} which will use an
estimated value depending on plot size}

\item{legend_label}{character. The title of the legend, which defaults to
\verb{"clone sizes}.}

\item{legend_text_size}{numeric. The text size of the letters and numbers on
the legend}

\item{add_legend_background}{logical. If \code{TRUE}, will add a border around the
legend and fill the background to be white, overlaying anything else.}

\item{verbose}{logical. Decides if visual cues are displayed to the R console
of the progress.}
}
\value{
A ggplot object of the APackOfTheClones clonal expansion plot of the
seurat object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function combines the functionality of both \code{RunAPOTC} and \code{APOTCPlot}.
Given a Seurat object, it first runs the APackOfTheClones method (\link{RunAPOTC})
to compute clonal expansion information, and then generates a customizable
ggplot2 object of the clonal expansion plot with a circle size legend
(\link{APOTCPlot}).
}
\examples{
data("combined_pbmc")

# plot with default parameters
vizAPOTC(combined_pbmc, verbose = FALSE)

# use arguments from RunAPOTC and APOTCPlot
vizAPOTC(
    combined_pbmc, try_place = TRUE, show_labels = TRUE, verbose = FALSE
)

}
