% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApotcIndexing.R
\name{deleteApotcData}
\alias{deleteApotcData}
\title{Delete the results of an APackOfTheClones run}
\usage{
deleteApotcData(seurat_obj, run_id)
}
\arguments{
\item{seurat_obj}{a seurat object that has had RunAPOTC ran on it before in
order of the functions being called.}

\item{run_id}{character. The id of the associated ApotcRun.}
}
\value{
The modified input seurat object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A convenience function to erase all data associated with a particular run,
including the ApotcData and command in seurat_obj@command. The run_id would
be no longer accessible afterwards.
}
\examples{
pbmc <- RunAPOTC(
    seurat_obj = get(data("combined_pbmc")),
    reduction_base = "umap",
    clonecall = "strict",
    run_id = "run1",
    verbose = FALSE
)

getApotcDataIds(pbmc)
#> [1] "run1"

# delete the data
pbmc <- deleteApotcData(pbmc, "run1")

getApotcDataIds(pbmc)
#> NULL

}
