% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantify.breaks.R
\name{quantify.breaks}
\alias{quantify.breaks}
\alias{quantBreakPoints}
\alias{quantBreakSegments}
\title{quantify break-point/segments}
\usage{
quantBreakPoints(
  data,
  pollutant,
  breaks,
  ylab = NULL,
  xlab = NULL,
  pt.col = c("lightgrey", "darkgrey"),
  line.col = "red",
  break.col = "blue",
  event = NULL,
  show = c("plot", "report"),
  ...
)

quantBreakSegments(
  data,
  pollutant,
  breaks,
  ylab = NULL,
  xlab = NULL,
  pt.col = c("lightgrey", "darkgrey"),
  line.col = "red",
  break.col = "blue",
  event = NULL,
  seg.method = 2,
  seg.seed = 12345,
  show = c("plot", "report"),
  ...
)
}
\arguments{
\item{data}{Data source, typically a data.frame or similar,
containing data-series to model and a paired time-stamp
data-series, named date.}

\item{pollutant}{The name of the data-series to
break-point or break-segment model.}

\item{breaks}{(Optional) The break-points and
confidence intervals to use when building either
break-point or break-segment models. If not supplied
these are build using \code{\link{findBreakPoints}}
and supplied arguments.}

\item{ylab}{Y-label term, by default pollutant.}

\item{xlab}{X-label term, by default date.}

\item{pt.col}{Point fill and line colours for plot,
defaults lightgrey and darkgrey.}

\item{line.col}{Line colour for plot, default red.}

\item{break.col}{Break-point/segment colour for plot, default
blue.}

\item{event}{An optional list of plot terms for an event
marker, applied to a vertical line and text label. List
items include: \code{x} the event date (YYYY-MM-DD format)
require for both line and label; \code{y} by default 0.9 x
y-plot range; \code{label} the label text, required for
label; \code{line.size} the line width, by default 0.5;
\code{font.size} the text size, by default 5; and,
\code{hjust} the label left/right justification, 0 left,
0.5 centre, 1 right (default). See also examples below.}

\item{show}{What to show before returning the break-point
quantification mode, by default plot and report.}

\item{...}{other parameters}

\item{seg.method}{(\code{quantBreakSegments} only) the
break-segment fitting method to use.}

\item{seg.seed}{(\code{quantBreakSegments} only) the
seed setting to use when fitting break-segments, default
\code{12345}.}
}
\value{
Both functions use the \code{show} argument
to control which elements of the functions outputs
are shown but also invisible return a \code{list}
of all outputs which can caught using, e.g.:

\code{brk.mod <- quantBreakPoints(data, pollutant)}
}
\description{
Quantify either break-points or
break-segment methods for pollutant time-series
}
\details{
\code{quantBreakPoints} and
\code{quantBreakSegments} both use
\code{strucchange} methods to identify potential
break-points in time-series, and then quantify
these as conventional break-points or break-segments,
respectively:
\itemize{
  \item \strong{Finding Break-points} Using the
  \code{strucchange} methods of Zeileis and colleagues
  and independent change detection model, the functions
  apply a rolling-window approach, assuming the first
  window (or data subset) is without change, building a
  statistical model of that, advancing the window,
  building a second model and comparing these, and so on,
  to identify the most likely points of change in a
  larger data-series. See also \code{\link{findBreakPoints}}
  \item \strong{Quantifying Break-points} Using the
  supplied break-points to build a break-point model.
  \item \strong{Quantifying Break-segments} Using the
  confidence regions for the supplied break-points as the
  starting points to build a break-segment model.
}
}
\note{
\code{AQEval} function \code{quantBreakSegments}
is currently running \code{segmented v.1.3-4} while we
evaluate latest version, \code{v.1.4-0}.
}
\examples{
#using openair timeAverage to covert 1-hour data to 1-day averages

temp <- openair::timeAverage(aq.data, "1 day")

#break-points

quantBreakPoints(temp, "no2", h=0.3)

#break-segments

quantBreakSegments(temp, "no2", h=0.3)

#addition examples (not run)
\dontrun{
#in-call plot modification
#removing x axis label
#recolouring break line and
#adding an event marker
quantBreakPoints(temp, "no2", h=0.3,
       xlab="", break.col = "red",
       event=list(label="Event expected here",
                 x="2002-08-01", col="grey"))
}
}
\references{
Regarding \code{strucchange} methods see in-package
documentation, e.g. \code{\link[strucchange]{breakpoints}},
and:

Achim Zeileis, Friedrich Leisch, Kurt Hornik and Christian Kleiber
(2002). strucchange: An R Package for Testing for Structural Change
in Linear Regression Models. Journal of Statistical Software, 7(2),
1-38. URL \url{https://www.jstatsoft.org/v07/i02/}.

Achim Zeileis, Christian Kleiber, Walter Kraemer and Kurt Hornik
(2003). Testing and Dating of Structural Changes in Practice.
Computational Statistics & Data Analysis, 44, 109-123.
DOI \doi{10.1016/S0167-9473(03)00030-6}.

Regarding \code{segmented} methods see in-package
documentation, e.g.
\code{\link[segmented]{segmented}}, and:

  Vito M. R. Muggeo (2003). Estimating regression models
  with unknown break-points. Statistics in Medicine, 22,
  3055-3071. DOI 10.1002/sim.1545.

  Vito M. R. Muggeo (2008). segmented: an R Package to
  Fit Regression Models with Broken-Line Relationships.
  R News, 8/1, 20-25.
  URL \url{https://cran.r-project.org/doc/Rnews/}.

  Vito M. R. Muggeo (2016). Testing with a nuisance
  parameter present only under the alternative: a
  score-based approach with application to segmented
  modelling. J of Statistical Computation and Simulation,
  86, 3059-3067.
  DOI 10.1080/00949655.2016.1149855.

  Vito M. R. Muggeo (2017). Interval estimation for the
  breakpoint in segmented regression: a smoothed
  score-based approach. Australian & New Zealand Journal
  of Statistics, 59, 311-322.
  DOI 10.1111/anzs.12200.

Regarding break-points/segment methods, see:

Ropkins et al (In Prep).
}
\seealso{
\code{\link{timeAverage}} in \code{openair},
\code{\link{breakpoints}} in \code{strucchange}, and
\code{\link{segmented}} in \code{segmented}.
}
\author{
Karl Ropkins
}
