% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_builders.R
\name{build_uecm_formula}
\alias{build_uecm_formula}
\title{UECM formula specification builder}
\usage{
build_uecm_formula(parsed_formula, order)
}
\arguments{
\item{parsed_formula}{A list containing the formula parts as returned from
\code{\link{parse_formula}}.}

\item{order}{A numeric vector with the underlying ARDL order as returned from
\code{\link[=parse_order]{parse_order(restriction = FALSE)}}.}
}
\value{
\code{build_uecm_formula} returns a list containing the full formula
  and the independent and dependent parts of the formula separated. The full
  formula is ready to be used as input in the \code{dynlm} function.
}
\description{
It creates the UECM (Unrestricted Error Correction Model) specification
according to the given "formula" and the corresponding "order" of the
underlying ARDL.
}
\seealso{
\code{\link{build_ardl_formula}}, \code{\link{build_recm_formula}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{internal}
