% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARPALdf_Summary.R
\name{ARPALdf_Summary}
\alias{ARPALdf_Summary}
\title{Summary statistics for a data frame of class 'ARPALdf'}
\usage{
ARPALdf_Summary(
  Data,
  by_IDStat = TRUE,
  by_Year = TRUE,
  gap_length = TRUE,
  correlation = TRUE,
  histogram = FALSE,
  density = FALSE,
  outlier = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{Data}{Dataset of class 'ARPALdf' containing the data to be summarised.}

\item{by_IDStat}{Logic value (TRUE or FALSE). Use TRUE (default) to compute summary statistics by Station ID.}

\item{by_Year}{Logic value (TRUE or FALSE). Use TRUE (default) to compute summary statistics by year.}

\item{gap_length}{Logic value (TRUE or FALSE). Use TRUE (default) to compute summary statistics for the gap length of each variable.}

\item{correlation}{Logic value (TRUE or FALSE). Use TRUE (default) to compute linear correlation of available variables.}

\item{histogram}{Logic value (TRUE or FALSE). Use TRUE to plot the histogram of each variable. Default is FALSE.}

\item{density}{Logic value (TRUE or FALSE). Use TRUE to plot the kernel density plot of each variable. Default is FALSE.}

\item{outlier}{Logic value (TRUE or FALSE). Use TRUE to analyse extreme values of each variable
(boxplot and Hampel filter). Default is FALSE.}

\item{verbose}{Logic value (TRUE or FALSE). Toggle warnings and messages. If 'verbose = TRUE' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose = FALSE' any message about
the progression is suppressed.}
}
\value{
A list of data.frames containing summary descriptive statistics for a data frame of class 'ARPALdf'.
Summary statistics are computed for the overall sample (Descr), by Station ID (Descr_by_IDStat) and by
year (Descr_by_Year). Available statistics are: number of NAs, % of NAs over the total sample, number of null values,
number of negative values, minimum, mean, maximum and standard deviation.
}
\description{
'ARPALdf_Summary' returns many descriptive statistics summaring the data contained in a data frame
of class ARPALdf. Statistics are calculated at overall level (full sample), by station ID and by year.
For each variable are reported the basic positioning indices (min, max, mean, median, quantile) and
variability indices (range, standard deviation). Other reported statistics are the Pearson's linear correlation
by station and some graphical representation of the distribution (kernel density plot, histogram, boxplot).
In addition, the function returns useful data-quality information, such as gap length statistics (i.e. number of
missing observations for each variable by station and by year) and outlier detection tools
(e.g., Hampel filter and boxplot rule)
}
\examples{
\donttest{
## Download daily air quality data from all the stations for year 2020
if (require("RSocrata")) {
  d <- get_ARPA_Lombardia_AQ_data(ID_station = NULL, Date_begin = "2020-01-01",
            Date_end = "2020-12-31", Frequency = "daily")
 }
## Summarising observed data
sum_stats <- ARPALdf_Summary(Data = d)
}

}
