% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Time_aggregate.R
\name{Time_aggregate}
\alias{Time_aggregate}
\title{Aggregate any ARPALdf object (with higher temporal frequency) to hourly, daily, weekly, monthly and yearly
temporal frequencies.}
\usage{
Time_aggregate(Dataset, Frequency, Var_vec = NULL, Fns_vec = NULL, verbose = T)
}
\arguments{
\item{Dataset}{ARPALdf dataframe to aggregate.}

\item{Frequency}{Temporal aggregation frequency. It can be "hourly", "daily", "weekly",
"monthly" or "yearly.}

\item{Var_vec}{Vector of variables to aggregate. If NULL (default) all the variables are averaged,
expect for 'Temperature' and 'Snow_height' which are summed.}

\item{Fns_vec}{Vector of aggregation functions to apply to the selected variables. Available functions
are 'mean', 'median', 'min', 'max', 'sum', 'qPP' (PP-th percentile), 'sd', 'var', 'vc' (variability coefficient),
'skew' (skewness) and 'kurt' (kurtosis). Attention: for Wind Speed and Wind Speed Gust only mean, min
and max are available; for Wind Direction and Wind Direction Gust only mean is available.}

\item{verbose}{Logic value (TRUE or FALSE). Toggle warnings and messages. If 'verbose=T' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose=F' any message about
the progression is suppressed.}
}
\value{
A data frame
}
\description{
Starting from an ARPALdf object with high frequency (e.g., 10mins or hourly), 'Time_aggregate'
aggregates the dataset to lower temporal frequencies (e.g., hourly, daily, weekly, monthly and yearly) by station.
The output is an ARPALdf object with observations having hourly, daily, weekly, monthly or yearly frequency.
The function can be applied only to ARPALdf objects.
User can indicate specific variables to aggregate and an aggregation function among
mean, median, sum (cumulated), min, max, quantiles, and variability metrics for each variable.
It is possible to specify different aggregation functions on the same variable
by repeating the name of the variable in 'Var_vec' and specifying the functions in 'Fns_vec'.
}
\examples{
\donttest{
## Download hourly observed concentrations from all the stations in the network during 2020.
if (require("RSocrata")) {
    data <- get_ARPA_Lombardia_AQ_data(ID_station=NULL, Date_begin = "2020-01-01",
                Date_end = "2020-12-31", Frequency="hourly")
}
## Aggregate all the data to daily frequency
Time_aggregate(Dataset=data,Frequency="daily",Var_vec=NULL,Fns_vec=NULL)
## Aggregate NO2 to weekly maximum concentrations and NOx to weekly minimum concentrations.
Time_aggregate(Dataset=data,Frequency="weekly",Var_vec=c("NO2","NOx"),Fns_vec=c("max","min"))
}

}
