% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndwi.R
\name{ndwi}
\alias{ndwi}
\title{Normalized Difference Water Index}
\usage{
ndwi(directory = getwd(), crop = "n", ext2crop = "none")
}
\arguments{
\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}
}
\value{
File named ndwi_'date of satellite image acqisition'.tif in the input folder
}
\description{
Normalized Difference Water Index (NDWI) is used to monitor changes related to water content in water bodies proposed by McFeeters (1996).
}
\note{
1. NDWI = (r_green - r_nir) / (r_nir + r_green)

where, "r_" denotes TOA reflectance band.

2. There is another NDWI to monitor changes in water content of leaves proposed by Gao (1996).
User should understand the requirements and run accordingly.

Other important notes are mentioned in \code{\link[ASIP]{custom.eqn}}.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
ndwi (directory = path, crop = "y", ext2crop = shapefil)
}
\references{
\href{http://www.tandfonline.com/doi/abs/10.1080/01431169608948714}{McFeeters, S.K. (1996) The Use of the Normalized Difference Water Index (NDWI) in the Delineation of Open Water Features. International Journal of Remote Sensing, 17, 1425-1432.
doi:10.1080/01431169608948714.}

\href{http://www.sciencedirect.com/science/article/pii/S0034425796000673}{Gao
Bo-cai (1996) NDWI-A normalized difference water index for remote sensing of vegetation liquid water from space. Remote Sensing of Environment, 58 (3), 257-266. doi:10.1016/S0034-4257(96)00067-3.}
}
