% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASSISTDesigns.R
\docType{class}
\name{DEFUSE3Design}
\alias{DEFUSE3Design}
\title{The DEFUSE3 design}
\format{An \code{\link{R6Class}} generator object}
\usage{
# design <- DEFUSE3Design$new(designParameters, trialParameters)
}
\description{
\code{DEFUSE3Design} is a slight variant of the the adaptive
clinical trial design of Lai, Lavori and Liao. Simulation is used to compute
the expected maximum sample size and the boundary for early futility is adjusted to
account as well.
}
\section{Methods}{


\describe{
\item{\code{DEFUSE3Design$new(designParameters, trialParameters, discreteData = FALSE, numberOfSimulations = 5000, rngSeed = 54321, showProgress = TRUE, boundaries)}}{Create
a new \code{DEFUSE3Design} instance object using the parameters specified. If \code{discreteData} is \code{TRUE} use a discrete distribution for the Rankin scores and \code{designParameters} must contain the appropriate distributions to sample from. If \code{boundaries} is specified, it is used.}
\item{\code{getDesignParameters},\code{getTrialParameters},
\code{getBoundaries}}{Accessor methods for (obvious) object slots}
\item{\code{setBoundaries}}{Modifier method for boundaries a
named vector of double values with names \code{btilde},
\code{b}, and \code{c}, in that order}
\item{\code{print()}}{Print the object in a human readable form}
\item{\code{adjustCriticalValues(numberOfSimulations, rngSeed, showProgress)}}{Adjust the critical values
by performing simulations using the parameters provided}
\item{\code{computeCriticalValues()}}{Compute the critical boundary value \eqn{c_\alpha}}
\item{\code{explore(numberOfSimulations = 5000, rngSeed = 12345, trueParameters = self$getDesignParameters(), recordStats = TRUE, showProgress = TRUE, saveRawData = FALSE)}}{Explore the design
using the specified number of simulations and random number seed.  \code{trueParameters} is by default the same
as \code{designParameters} as would be the case for a Type I error calculation. If changed, would yield power.
Record statistics, save raw data and show progress if so desired. Returns a list of results}
\item{\code{analyze(trialHistory)}}{Analyze
the design given the \code{trialHistory} which is the result of a call to \code{explore} to
simulate the design. Return a list of summary quantities}
\item{\code{summary(analysis)}}{Print the operating characteristics of the design, using the analysis
result from the \code{analyze} call}
}
}

\examples{
trialParameters <- list(N = c(200, 340, 476), type1Error = 0.025,
                        eps = 1/2, type2Error = 0.1)
designParameters <- list(
   nul0 = list(prevalence = rep(1/6, 6), mean = matrix(0, 2, 6),
               sd = matrix(1, 2, 6)),
   alt1 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.5, 0.4, 0.3, 0, 0, 0)),
               sd = matrix(1, 2, 6)),
   alt2 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.5, 0.5, 0, 0, 0, 0)),
               sd = matrix(1,2, 6)),
   alt3 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6), rep(0.36, 6)),
               sd = matrix(1,2, 6)),
   alt4 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6), rep(0.30, 6)),
               sd = matrix(1,2, 6)),
   alt5 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.4, 0.3, 0.2, 0, 0, 0)),
               sd = matrix(1,2, 6)),
   alt6 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.5, 0.5, 0.3, 0.3, 0.1, 0.1)),
               sd = matrix(1,2, 6)))

\dontrun{
## A realistic design uses 5000 simulations or more!
defuse3 <- DEFUSE3Design$new(trialParameters = trialParameters,
                             numberOfSimulations = 25,
                             designParameters = designParameters$nul0,
                             showProgress = FALSE)
print(defuse3)
result <- defuse3$explore(showProgress = interactive())
analysis <- defuse3$analyze(result)
print(defuse3$summary(analysis))
}
## For full examples, try:
## browseURL(system.file("full_doc/defuse3.html", package="ASSISTant"))

}
\references{
Adaptive design of confirmatory trials: Advances and challenges, 2015 45(Pt A):93-102,
by Tze Leung Lai and Philip W. Lavori and Ka Wai Tsang. doi:10.1016/j.cct.2015.06.007
}
\seealso{
\code{ASSISTDesign} which is a superclass of this object
}
\keyword{datasets}
