% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_single_epidemic.R
\name{plot_single_epidemic}
\alias{plot_single_epidemic}
\title{Plot a single epidemic simulation}
\usage{
plot_single_epidemic(epidemic, epidemic_num)
}
\arguments{
\item{epidemic}{A list containing the results of a single epidemic simulation, typically an
element from an "ssir_epidemic_multi" object.}

\item{epidemic_num}{An integer indicating the epidemic number, used in the plot titles.}
}
\value{
A grid arrangement of two ggplot objects: new infections and reported cases.
}
\description{
This function creates two plots for a single epidemic simulation: one for new infections and
one for reported cases.
}
\examples{
# Assuming you have run a simulation:
result <- ssir(N = 10000, T = 300, alpha = 0.3, inf_period = 4, inf_init = 32,
report = 0.02, lag = 7)
plot_single_epidemic(result, 1)

# For multiple simulations:
multi_result <- ssir(N = 10000, T = 300, alpha = 0.3, inf_period = 4, inf_init = 32,
report = 0.02, lag = 7, rep = 5)
plot_single_epidemic(multi_result[[1]], 1)

}
