% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1_plot_CI.R
\name{step1_plot_CI}
\alias{step1_plot_CI}
\title{Plot Confidence Intervals}
\usage{
step1_plot_CI(
  step1_down_object,
  xname = NULL,
  yname = NULL,
  xlim = NULL,
  ylim = NULL,
  ribbon = FALSE
)
}
\arguments{
\item{step1_down_object}{The fit object from the step1.down function (required).}

\item{xname}{Label for the x-axis (optional).}

\item{yname}{Label for the y-axis (optional).}

\item{xlim}{x-axis limits (optional).}

\item{ylim}{y-axis limits (optional).}

\item{ribbon}{Add shade to confidence intervals (optional).}
}
\value{
Plot of stability data with prediction curves and confidence intervals.
}
\description{
Plot the stability data and visualise the predictions with
confidence intervals.
}
\details{
Use the fit object obtained from the step1.down function to plot the
data and visualise the predictions with confidence intervals applied.
There is an option to view the confidence intervals as a ribbon. The
confidence interval value is chosen in the step1.down function.
}
\examples{
#load antigenciity data
data(antigenicity)

#run step1.down fit
fit1 <- step1_down(data = antigenicity, y = "conc", .time = "time",
 C = "Celsius", max_time_pred = 3, confidence_interval = 0.9)

#plot raw data with prediction curves and confidence intervals.
step1_plot_CI(step1_down_object = fit1, xlim = NULL, ylim = NULL,
 xname = "Time (Years)", yname = "Concentration", ribbon = TRUE)

}
