% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1_plot_pred.R
\name{step1_plot_pred}
\alias{step1_plot_pred}
\title{Plot Model Predictions}
\usage{
step1_plot_pred(
  step1_down_object,
  xname = NULL,
  yname = NULL,
  xlim = NULL,
  ylim = NULL
)
}
\arguments{
\item{step1_down_object}{The fit object from the step1.down function (required).}

\item{xname}{Label for the x-axis (optional).}

\item{yname}{Label for the y-axis (optional).}

\item{xlim}{x-axis limits (optional).}

\item{ylim}{y-axis limits (optional).}
}
\value{
Plot of accelerated stability data with prediction curves.
}
\description{
Plot the stability data and visualise the predictions.
}
\details{
Use the fit object from the step1.down function to plot the accelerated
stability data and visualise the predictions.
}
\examples{
#load antigenicity data
data(antigenicity)

fit1 <- step1_down(data = antigenicity, y = "conc", .time = "time",
 C = "Celsius", max_time_pred = 3)

step1_plot_pred(step1_down_object = fit1, xlim = NULL, ylim = NULL,
 xname = "Time (Years)", yname = "Concentration")

}
