% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancer_genes-data.R
\docType{data}
\name{cancer_genes}
\alias{cancer_genes}
\title{cancer_genes}
\format{
A data frame containing the following columns: chr, start, end, id
\describe{
    \item{chr}{autosomal chromosomes as chr1 to chr22 and sex chromosomes as chrX and chrY}
    \item{start}{the start position of the element in base 0 coordinates (BED format)}
    \item{end}{the end position of the element in base 0 coordinates (BED format)}
    \item{id}{the element identifier - if the element contains multiple segments such as exons, each segment should be a separate row with the segment coordinates and the element identifier as id. Elements can be coding or noncoding such as exons of protein coding genes or active enhancers.}
}
}
\source{
\href{https://www.gencodegenes.org/human/release_19.html}{GENCODE}
}
\usage{
data(cancer_genes)
}
\description{
protein coding genes from gencode v.19, cancer genes adapted from the Cancer Gene Census (November, 2018).
Genes affected solely by amplifications, deletions and translations were removed.
}
\examples{
data(cancer_genes)
\donttest{
data(cll_mutations)
ActiveDriverWGS(mutations = cll_mutations, elements = cancer_genes)
}
}
\references{
Harrow, Jennifer, et al. "GENCODE: the reference human genome annotation for The ENCODE Project." Genome research 22.9 (2012): 1760-1774.
(\href{https://pubmed.ncbi.nlm.nih.gov/22955987/}{PubMed})
}
\keyword{datasets}
