\name{AdaptGauss}
\alias{AdaptGauss}

\title{Adapt Gaussian Mixture Model (GMM)}
\description{
  Adapt interactively a Gaussians Mixture Model GMM to the empirical PDF
  of the data (generated by ParetoDensityEstimation) such that N(Means,SDs)*Weights is a  model for Data
}
\usage{
AdaptGauss(Data,Means,SDs,Weights,ParetoRadius,LB,HB,ListOfAdaptGauss,fast)
}

\arguments{
  \item{Data}{ Data for empirical PDF. Has to be an Array of values. NaNs
  and NULLs will be deleted }
  \item{Means}{ Optional: Means of gaussians of GMM. }
  \item{SDs}{ Optional: StandardDevations of gaussians of GMM. (Has to be the same length as Means) }
  \item{Weights}{ Optional: Weights of gaussians of GMM. (Has to be the same length as Means) }
  \item{ParetoRadius}{ Optional: Pareto Radius of Pareto Desity Estimation (PDE). }
  \item{LB}{ Optional: Low boundary of estimation. All values below LB will be deleted. Default: min(Data) }
  \item{HB}{ Optional: High boundary of estimation. All values above HB will be deleted. Default: max(Data) }
	\item{ListOfAdaptGauss}{Optional: If editing of an existing Model is the goal, enables to give the Output of AdaptGaus as the Input of AdaptGauss() instead of setting Means, SDs and Weights separately}
	\item{fast}{Default=TRUE; FALSE: Using mclust's EM see function \code{densityMclust} of that package, TRUE: Naive but faster EM implementation, which may be numerical unstable, because log(gauss) is not used}

	}
\details{
  Data: maximum length is 10000. If larger, Data will be randomly reduced to 10000 Elements.
  MeansIn/DeviationsIn/WeightsIN: If empty, either one or three Gaussian's are generated by kmeans algorithm.
  Pareto Radius: If empty: will be generated by ParetoDensityEstimation
	RMS:  Root Mean Square error is normalized by RMS of Gaussian's with Mean=mean(data) and SD=sd(data), see [Ultsch et.al., 2015] for further details.
}
\value{
List with
  \item{Means}{Means of Gaussian's.}
  \item{SDs}{Standard SDs of Gaussian's.}
  \item{Weights}{Weights of Gaussian's.}
  \item{ParetoRadius}{Pareto Radius: Either ParetoRadiusIn, the pareto radius enerated by PretoDensityEstimation(if no Pareto Radius in Input).}
  \item{RMS}{Root Mean Square of Deviation between Gaussian Mixture Model GMM to the empirical PDF. Normalized by RMS of one Gaussian with mean=meanrobust(data) and sdev=stdrobust(data). Further Details in [Ultsch et al 2015]}
	\item{BayesBoundaries}{vector[1:L-1], Bayes decision boundaries}
  }

\author{Onno Hansen-Goos, Michael Thrun}

\examples{

  data1=c(rnorm(1000))
  \dontrun{Vals1=AdaptGauss(data1)}
  
  data2=c(rnorm(1000),rnorm(2000)+2,rnorm(1000)*2-1)
  \dontrun{Vals2=AdaptGauss(data2,c(-1,0,2),c(2,1,1),c(0.25,0.25,0.5),0.3,-6,6)}
  
  
 }
 \references{
Alfred Ultsch, Michael C. Thrun, Onno Hansen-Goos, Joern Loetsch Identification of molecular fingerprints in heat pain thresholds by use of an interactive mixture model toolbox (AdaptGauss), IJMS 2015.

Thrun M.C.,Ultsch, A., Models of Income Distributions for Knowledge Discovery, European Conference on Data Analysis, DOI 10.13140/RG.2.1.4463.0244, Colchester 2015.
}
 
\keyword{GMM}

\keyword{ MultiModal }

\keyword{gaussian mixture model}

\keyword{mixture}