% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{print.CMA0}
\alias{print.CMA0}
\alias{print.CMA1}
\alias{print.CMA2}
\alias{print.CMA3}
\alias{print.CMA4}
\alias{print.CMA5}
\alias{print.CMA6}
\alias{print.CMA7}
\alias{print.CMA8}
\alias{print.CMA9}
\alias{print.CMA_per_episode}
\alias{print.CMA_sliding_window}
\title{Print CMA0 (and derived) objects.}
\usage{
\method{print}{CMA0}(x, ..., inline = FALSE, format = c("text", "latex",
  "markdown"), print.params = TRUE, print.data = TRUE,
  exclude.params = c("event.info"), skip.header = FALSE,
  cma.type = class(cma)[1])

\method{print}{CMA1}(...)

\method{print}{CMA2}(...)

\method{print}{CMA3}(...)

\method{print}{CMA4}(...)

\method{print}{CMA5}(...)

\method{print}{CMA6}(...)

\method{print}{CMA7}(...)

\method{print}{CMA8}(...)

\method{print}{CMA9}(...)

\method{print}{CMA_per_episode}(x, ..., inline = FALSE, format = c("text",
  "latex", "markdown"), print.params = TRUE, print.data = TRUE,
  exclude.params = c("event.info"), skip.header = FALSE,
  cma.type = class(cma)[1])

\method{print}{CMA_sliding_window}(...)
}
\arguments{
\item{x}{A \emph{\code{CMA0}} or derived object, representing the CMA to
print.}

\item{...}{other possible parameters}

\item{inline}{\emph{Logical}, should print inside a line of text or as a
separate, extended object?}

\item{format}{A \emph{string}, the type of output: plain text ("text";
default), LaTeX ("latex") or R Markdown ("markdown").}

\item{print.params}{\emph{Logical}, should print the parameters?}

\item{print.data}{\emph{Logical}, should print a summary of the data?}

\item{exclude.params}{A vector of \emph{strings}, the names of the object
fields to exclude from printing (usually, internal information irrelevant to
the end-user).}

\item{skip.header}{\emph{Logical}, should the header be printed?}

\item{cma.type}{A \emph{string}, used to override the reported object's class.}
}
\description{
Prints and summarizes a basic CMA0, or derived, object.
}
\details{
Can produce output for the console (text), R Markdown or LaTeX,
showing various types of information.
}
\examples{
cma0 <- CMA0(data=med.events,
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             event.daily.dose.colname="PERDAY",
             medication.class.colname="CATEGORY",
             followup.window.start=0,
             followup.window.start.unit="days",
             followup.window.duration=2*365,
             followup.window.duration.unit="days",
             observation.window.start=30,
             observation.window.start.unit="days",
             observation.window.duration=365,
             observation.window.duration.unit="days",
             date.format="\%m/\%d/\%Y",
             summary="Base CMA");
cma0;
print(cma0, format="markdown");
cma1 <- CMA1(data=med.events,
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             followup.window.start=30,
             observation.window.start=30,
             observation.window.duration=365,
             date.format="\%m/\%d/\%Y"
            );
cma1;
}
