% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_function.R
\docType{data}
\name{durcomp.dispensing}
\alias{durcomp.dispensing}
\title{Example dispensing events for 16 patients.}
\format{A data frame with 1794 rows and 6 variables:
\describe{
  \item{ID}{\emph{integer} here; patient unique identifier. Can also
  be \emph{string}.}
  \item{DATE.DISP}{\emph{Date} here;the dispensing event date, by default in the
  yyyy-mm-dd format. Can also be \emph{string}.}
  \item{ATC.CODE}{\emph{character}; the medication type, according to the WHO ATC
  classification system. This can be a researcher-defined classification
  depending on study aims (e.g., based on therapeutic use, mechanism of
  action, chemical molecule, or pharmaceutical formulation). The \code{compute_event_durations}
  function will match prescribed medication to dispensed medications based on this variable.}
  \item{UNIT}{\emph{integer}; the unit of the dispensed dose. This is optional and can be used
  as a separate variable to match between prescription and dispensing events.}
  \item{FORM}{\emph{character}; the galenic form of the dispensed preparation.
  This is optional and can be used as a separate variable to match between prescription and
  dispensing events.}
  \item{TOTAL.DOSE}{\emph{numeric}; the total dispensed dose supplied at this
  medication event (e.g., \code{5000} for 10 tables of 500 mg).}
}}
\usage{
durcomp.dispensing
}
\description{
A sample dataset containing dispensing events (one per row) for 16 patients
over a period of roughly 24 months (1794 events in total).
This is the appropriate format to compute event durations with the
\code{compute_event_durations} function. Each row represents an individual dispensing
record for a specific dose of a specific medication for a patient at a given date.
More than one column to group medications can be supplied (such as ATC code, Form and Unit).
}
\keyword{datasets}
