% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_params_2.R
\name{set_params_2}
\alias{set_params_2}
\title{Make a set of particle-size-dependent parameters}
\usage{
set_params_2(df, params)
}
\arguments{
\item{df}{is the particle data set (data frame) established with the
`particle_dist` function}

\item{params}{is the parameter data set for parameters that are not
particle size-dependent}
}
\value{
a data frame starting with the submitted particle
distribution with additional columns for particle-size-dependent
parameters
}
\description{
This set of parameters will be used for evaluation of transport
efficiency for particle-size-dependent parameters.
}
\details{
No user-selected arguments are needed. Parameters are used in
efficiency functions. For each particle diameter, an entry is
made in the data frame for the Cunningham slip correction factor,
the particle terminal velocity, the particle Reynold's number,
and the Stokes factor.

`set_params_1` sets all single parameters.
`set_params_2` adds particle size-dependent parameters to the
particle distribution
}
\examples{
df <- particle_dist()
params <- set_params_1("D_tube" = 2.54, "Q_lpm" = 100,
"T_C" = 25, "P_kPa" = 101.325)
df <- set_params_2(df, params)
head(df)

}
