% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tube_eff.R
\name{tube_eff}
\alias{tube_eff}
\title{Tube efficiency}
\usage{
tube_eff(df, params, L, angle_to_horiz, elnum)
}
\arguments{
\item{df}{is the particle data set (data frame) established with the
`particle_dist` function}

\item{params}{is the parameter data set for parameters that are not
particle size-dependent}

\item{L}{tube length, m}

\item{angle_to_horiz}{angle to horizontal in degrees}

\item{elnum}{element number to provide unique column names}
}
\value{
data frame containing original particle distribution with added
data for this element
}
\description{
In order to run this function, first produce a particle distribution
with the `particle_dist` function, then produce a parameter set with
the `set_params` function. Both of these results must be stored as
per examples described in the help set with each.
}
\examples{
df <- particle_dist() #  distribution
params <- set_params_1("D_tube" = 2.54, "Q_lpm" = 100,
"T_C" = 25, "P_kPa" = 101.325) #example system parameters
df <- set_params_2(df, params) #particle size-dependent parameters
df <- probe_eff(df, params, orient = 'h') #probe orientation - horizontal
df <- tube_eff(df, params, L = 100,
angle_to_horiz = 90, elnum = 3)
head(df)

}
