% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbct_function.R
\name{DBCT}
\alias{DBCT}
\title{Analysis: Randomized block design evaluated over time}
\usage{
DBCT(
  trat,
  block,
  time,
  response,
  alpha.f = 0.05,
  alpha.t = 0.05,
  theme = theme_classic(),
  geom = "bar",
  fill = "gray",
  ylab = "Response",
  xlab = "Independent",
  mcomp = "tukey",
  textsize = 12,
  labelsize = 5,
  error = TRUE,
  family = "sans",
  sup = 0,
  addmean = FALSE,
  posi = c(0.1, 0.8),
  legend = "Legend",
  ylim = NA,
  width.bar = 0.1,
  dec = 3,
  xnumeric = FALSE,
  all.letters = FALSE
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{block}{Numerical or complex vector with blocks}

\item{time}{Numerical or complex vector with times}

\item{response}{Numerical vector containing the response of the experiment.}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{alpha.t}{Significance level of the multiple comparison test (\emph{default} is 0.05)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{geom}{Graph type (columns - "bar" or segments "point")}

\item{fill}{Defines chart color (to generate different colors for different treatments, define fill = "trat")}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{mcomp}{Multiple comparison test (Tukey (\emph{default}), LSD ("lsd"), Scott-Knott ("sk"), Duncan ("duncan") and Friedman ("fd"))}

\item{textsize}{Font size of the texts and titles of the axes}

\item{labelsize}{Font size of the labels}

\item{error}{Add error bar}

\item{family}{Font family}

\item{sup}{Number of units above the standard deviation or average bar on the graph}

\item{addmean}{Plot the average value on the graph (\emph{default} is TRUE)}

\item{posi}{Legend position}

\item{legend}{Legend title}

\item{ylim}{y-axis scale}

\item{width.bar}{width errorbar}

\item{dec}{Number of cells}

\item{xnumeric}{Declare x as numeric (\emph{default} is FALSE)}

\item{all.letters}{Adds all label letters regardless of whether it is significant or not.}
}
\value{
The function returns the p-value of Anova, the assumptions of normality of errors, homogeneity of variances and independence of errors, multiple comparison test, as well as a line graph
}
\description{
Function of the AgroR package for analysis of experiments conducted in a balanced qualitative, single-factorial randomized block design with multiple assessments over time, however without considering time as a factor.
}
\details{
The p-value of the analysis of variance, the normality test for Shapiro-Wilk errors, the Bartlett homogeneity test of variances, the independence of Durbin-Watson errors and the multiple comparison test (Tukey, Scott-Knott, LSD or Duncan).
}
\note{
The ordering of the graph is according to the sequence in which the factor levels are arranged in the data sheet. The bars of the column and segment graphs are standard deviation.
}
\examples{
rm(list=ls())
data(simulate2)
attach(simulate2)

#===================================
# default
#===================================
DBCT(trat, bloco, tempo, resp)

#===================================
# segment chart
#===================================
DBCT(trat, bloco, tempo, resp, geom="point")
}
\references{


Principles and procedures of statistics a biometrical approach Steel & Torry & Dickey. Third Edition 1997

Multiple comparisons theory and methods. Departament of statistics the Ohio State University. USA, 1996. Jason C. Hsu. Chapman Hall/CRC.

Practical Nonparametrics Statistics. W.J. Conover, 1999

Ramalho M.A.P., Ferreira D.F., Oliveira A.C. 2000. Experimentacao em Genetica e Melhoramento de Plantas. Editora UFLA.

Scott R.J., Knott M. 1974. A cluster analysis method for grouping mans in the analysis of variance. Biometrics, 30, 507-512.
}
\seealso{
\link{DBC}, \link{DICT}, \link{DQLT}
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Gonçalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Experimental}
\keyword{dbct}
