% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FAT2DBCart_function.R
\name{FAT2DBC.art}
\alias{FAT2DBC.art}
\title{Analysis: Analysis of Variance of Aligned Rank Transformed Data in FAT2DBC}
\usage{
FAT2DBC.art(
  f1,
  f2,
  block,
  response,
  decreasing = TRUE,
  xlab = " ",
  ylab = "Sum of posts",
  legend.title = "Factor",
  sup = NA,
  theme = theme_classic()
)
}
\arguments{
\item{f1}{Numeric or complex vector with factor 1 levels}

\item{f2}{Numeric or complex vector with factor 2 levels}

\item{block}{Numerical or complex vector with blocks}

\item{response}{Numerical vector containing the response of the experiment.}

\item{decreasing}{letter order (\emph{default} is TRUE)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{legend.title}{legend title name}

\item{sup}{Number of units above the standard deviation or average bar on the graph}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}
}
\value{
The function returns the Anova of aligned ranks, the multiple comparison test and the interaction graph.
}
\description{
Apply the aligned rank transform to a factorial model (with optional grouping terms). Usually done in preparation for a nonparametric analyses of variance on models with numeric or ordinal responses, which can be done by following up with anova.art.
}
\examples{
data(cloro)
with(cloro, FAT2DBC.art(f1,f2,bloco,resp))
}
\references{
Wobbrock, J. O., Findlater, L., Gergle, D., Higgins, J. J. (2011, May). The aligned rank transform for nonparametric factorial analyses using only anova procedures. In Proceedings of the SIGCHI conference on human factors in computing systems (pp. 143-146).

Kay, M., Wobbrock, J. O. (2020). Package ‘ARTool’.
}
\seealso{
\link{FAT2DBC}
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
