#' Dataset: Eucaliptus grandis Barbin (2013)
#'
#' The data refer to the height in meters of *Eucalyptus grandis* plants,
#' with 7 years of age, from three trials (Araraquara - Exp 1; Bento
#' Quintino - Exp 2; Mogi-Guacu - Exp 3) in randomized blocks, under
#' 6 progenies. The data were taken from the book by Decio Barbin
#' (2013) and are from the Instituto Florestal de Tupi/SP.
#'
#' @docType data
#'
#' @usage data("eucalyptus")
#'
#' @references Planejamento e Analise Estatistica de Experimentos Agronomicos (2013) - Decio Barbin - pg. 177
#'
#' @format data.frame containing data set
#'   \describe{
#'   \item{\code{trati}}{Categorical vector with treatments}
#'   \item{\code{bloc}}{Categorical vector with block}
#'   \item{\code{exp}}{Categorical vector with experiment}
#'   \item{\code{resp}}{Numeric vector}
#'   }
#'
#' @keywords datasets
#'
#' @seealso \link{cloro}, \link{enxofre}, \link{laranja}, \link{pomegranate}, \link{porco}, \link{sensorial}, \link{simulate1}, \link{simulate2}, \link{simulate3}, \link{tomate}, \link{weather}
#'
#' @examples
#' data(eucalyptus)
"eucalyptus"
