% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AirSensor.R
\docType{data}
\name{ArchiveBaseUrl}
\alias{ArchiveBaseUrl}
\title{Base URL for pre-generated data}
\format{
URL string.
}
\description{
This package maintains an internal archive base URL which users 
can set using \code{setArchiveBaseUrl()}. Alternatively, if an archive of 
pre-generated data files is availalbe locally, users can set the location of 
this directory with\code{setArchiveBaseDir()}.

To avoid internet latency, specification of BASE_DIR will always take 
precedence over specification of BASE_URL.
Known base URLs include:
\itemize{
\item{http://data.mazamascience.com/PurpleAir/v1}
}

Package functions that load pre-generated data files download data from this
URL. These functions include:

\itemize{
\item{\code{pas_load()}}
\item{\code{pat_load()}}
\item{\code{pat_loadLatest()}}
\item{\code{pat_loadMonth()}}
\item{\code{sensor_load()}}
\item{\code{sensor_loadLatest()}}
\item{\code{sensor_loadMonth()}}
}
}
\seealso{
getArchiveBaseUrl

setArchiveBaseUrl

setArchiveBaseDIR
}
\keyword{environment}
