% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializeMazamaSpatialUtils.R
\name{initializeMazamaSpatialUtils}
\alias{initializeMazamaSpatialUtils}
\title{Initialize MazamaSpatialUtils package}
\usage{
initializeMazamaSpatialUtils(
  spatialDataDir = "~/Data/Spatial",
  stateCodeDataset = "NaturalEarthAdm1",
  logLevel = WARN
)
}
\arguments{
\item{spatialDataDir}{Directory where spatial datasets are created.}

\item{stateCodeDataset}{MazamaSpatialUtils dataset returning ISO 3166-2 .
alpha-2 stateCodes}

\item{logLevel}{Logging level used if logging has not already been 
initialized.}
}
\description{
Convenience function that wraps:

\preformatted{
  data("SimpleCountriesEEZ", package = "MazamaSpatialUtils")
  data("SimpleTimezones", package = "MazamaSpatialUtils")
  MazamaSpatialUtils::setSpatialDataDir('~/Data/Spatial')
  MazamaSpatialUtils::loadSpatialData('NaturalEarthAdm1')
}

This function should be run before using \code{pas_load()}, as 
\code{pas_load()} uses the spatial data loaded by 
\code{initializeMazamaSpatialUtils()} to enhance  raw synoptic data via 
\code{pas_enhanceData()}.

If file logging is desired, these commands should be run individually with
output log files specified as arguments to \code{logger.setup()} from the
\pkg{MazamaCoreUtils} package.
}
