% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_createNew.R
\name{pat_createNew}
\alias{pat_createNew}
\title{Load latest PurpleAir time series data}
\usage{
pat_createNew(
  id = NULL,
  label = NULL,
  pas = NULL,
  startdate = NULL,
  enddate = NULL,
  timezone = NULL,
  baseUrl = "https://api.thingspeak.com/channels/",
  verbose = FALSE
)
}
\arguments{
\item{id}{PurpleAir sensor 'deviceDeploymentID'.}

\item{label}{PurpleAir sensor 'label'.}

\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{startdate}{Desired UTC start time (ISO 8601) or \code{POSIXct}.}

\item{enddate}{Desired UTC end time (ISO 8601) or \code{POSIXct}.}

\item{timezone}{Timezone used to interpret start and end dates.}

\item{baseUrl}{Base URL for Thingspeak API.}

\item{verbose}{Logical controlling the generation of warning and error messages.}
}
\value{
A PurpleAir Timeseries \emph{pat} object.
}
\description{
Retrieve and parse timeseries data from the Thingspeak API for 
specific PurpleAir sensors.

Dates can be anything that is understood by 
\code{MazamaCoreUtils::parseDatetime()} including any of the following 
recommended formats:

\itemize{
\item{\code{"YYYYmmdd"}}
\item{\code{"YYYY-mm-dd"}}
\item{\code{"YYYY-mm-dd HH:MM:SS"}}
}
}
\note{
When \code{timezone = NULL}, the default, dates are interpreted to be 
in the local timezone for the sensor of interest.

Starting with \pkg{AirSensor} version 0.6, archive file names are 
generated with a unique "device-deployment" identifier by combining a unique 
location ID with a unique device ID. These "device-deployment" identifiers 
guarantee that movement of a sensor will result in the creation of a new
time series.

Users may request a \emph{pat} object in one of two ways:

1) Pass in \code{id} with a valid a \code{deviceDeploymentID}

2) Pass in both \code{label} and \code{pas} so that the 
\code{deviceDeploymentID} can be looked up.
}
\examples{
\donttest{
library(AirSensor)

pat <- pat_createNew(
  label = "Seattle", 
  pas = example_pas, 
  startdate = 20180701, 
  enddate = 20180901
)
pat_multiPlot(pat)
}
}
\seealso{
\link{pat_downloadParseRawData}
}
