% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_downloadParseRawData.R
\name{pat_downloadParseRawData}
\alias{pat_downloadParseRawData}
\title{Download PurpleAir timeseries data}
\usage{
pat_downloadParseRawData(
  id = NULL,
  label = NULL,
  pas = NULL,
  startdate = NULL,
  enddate = NULL,
  timezone = NULL,
  baseUrl = "https://api.thingspeak.com/channels/"
)
}
\arguments{
\item{id}{PurpleAir sensor 'deviceDeploymentID'.}

\item{label}{PurpleAir sensor 'label'.}

\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{startdate}{Desired start time (ISO 8601).}

\item{enddate}{Desired end time (ISO 8601).}

\item{timezone}{Timezone used to interpret start and end dates.}

\item{baseUrl}{Base URL for Thingspeak API.}
}
\value{
List containing multiple timeseries dataframes.
}
\description{
Downloads timeseries data for a specific PurpleAir sensor 
from the ThingSpeak API and parses the content into individual dataframes. This 
function will always return dataframes with the appropriate columns even if no 
data are returned from ThingSpeak.

The returned list contains the following dataframes:

\itemize{
\item{\code{meta} -- \code{pas} records for the specified sensor}
\item{\code{A_PRIMARY} -- channel A primary dataset}
\item{\code{A_SECONDARY} -- channel A secondary dataset}
\item{\code{B_PRIMARY} -- channel B primary dataset}
\item{\code{B_SECONDARY} -- channel B secondary dataset}
}

These dataframes contain \strong{ALL} data available from ThingSpeak for the
specified sensor and time period.

See the references.
}
\examples{
\donttest{
library(AirSensor)

setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

pas <- pas_load()

pat_rawList <- 
  pat_downloadParseRawData(
    id = "78df3c292c8448f7_21257",
    pas = pas
  )

lapply(pat_rawList, head)
}
}
\references{
\url{https://www2.purpleair.com/community/faq#!hc-sd-card-csv-file-header}
}
