% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-sensor.R
\name{sensor_extractDataFrame}
\alias{sensor_extractDataFrame}
\alias{sensor_extractData}
\alias{sensor_extractMeta}
\title{Extract dataframes from \emph{airsensor} objects}
\usage{
sensor_extractData(sensor)

sensor_extractMeta(sensor)
}
\arguments{
\item{sensor}{\emph{sensor} object to extract dataframe from.}
}
\value{
A dataframe from the given \emph{sensor} object
}
\description{
These functions are convenient wrappers for extracting the dataframes that
comprise a \emph{airsensor} object. These functions are designed to be useful
when manipulating data in a pipeline chain using \code{\%>\%}.

Below is a table showing equivalent operations for each function.

\tabular{ll}{
  \strong{Function} \tab \strong{Equivalent Operation}\cr
  \code{sensor_extractData(sensor)} \tab \code{sensor[["data"]]}\cr
  \code{sensor_extractMeta(sensor)} \tab \code{sensor[["meta"]]}
}
}
