% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseriesTbl_multiPlot.R
\name{timeseriesTbl_multiPlot}
\alias{timeseriesTbl_multiPlot}
\title{Faceted plot of a timeseries tibble}
\usage{
timeseriesTbl_multiPlot(
  tbl = NULL,
  pattern = NULL,
  parameters = NULL,
  nrow = NULL,
  ncol = NULL,
  autoRange = TRUE,
  ylim = NULL,
  style = "line"
)
}
\arguments{
\item{tbl}{Tibble with a \code{datetime}.}

\item{pattern}{Pattern used to match groups of parameters.}

\item{parameters}{Custom vector of aggregation parameters to view.}

\item{nrow}{Number of rows in the faceted plot.}

\item{ncol}{Number of columns in the faceted plot.}

\item{autoRange}{Logical specifying whether to scale the y axis separately
for each plot or to use a common y axis.}

\item{ylim}{Vector of (lo,hi) y-axis limits.}

\item{style}{Style of plot: ("point", "line", "area")}
}
\description{
A plotting function that uses ggplot2 to display a suite of
timeseries plots all at once.
}
\note{
Specification of \code{ylim} will override the choice of
\code{autoRange}.
}
\examples{
\donttest{
library(AirSensor)

tbl <- pat_aggregateOutlierCounts(example_pat_failure_A)

timeseriesTbl_multiPlot(
  tbl,
  pattern = c("humidity|temperature"),
  nrow = 2
)
}
}
