# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Count Variants and Carriers
#'
#' @param anno (snps x 1) annotation vector with values in c(0, 1, 2).
#' @param geno (n x snps) genotype matrix.
#' @param min_mac Minimum minor allele count for inclusion. Default: 0.
#' @return Data.frame of allele, variant, and carrier counts.
#' @export
Counts <- function(anno, geno, min_mac = 0L) {
    .Call(`_AllelicSeries_Counts`, anno, geno, min_mac)
}

#' Ordinary Least Squares
#'
#' Fits the standard OLS model.
#'
#' @param y (n x 1) Numeric vector.
#' @param X (n x p) Numeric matrix.
#'
#' @return List containing the following:
#' \itemize{
#' \item{beta: Regression coefficients.}
#' \item{v: Residual variance.}
#' \item{se: Standard errors.}
#' \item{z: Z-scores.}
#' \item{pval: P-values based on the chi2 distribution.}
#' }
#' @export
OLS <- function(y, X) {
    .Call(`_AllelicSeries_OLS`, y, X)
}

#' Calculate Residual Variance
#'
#' @param y (n x 1) Numeric phenotype vector.
#' @param X (n x q) Numeric covariate matrix.
#'
#' @return Scalar residual variance.
ResidVar <- function(y, X) {
    .Call(`_AllelicSeries_ResidVar`, y, X)
}

#' Calculate Score Statistic
#'
#' @param y (n x 1) Numeric phenotype vector.
#' @param G (n x p) Numeric genotype matrix.
#' @param X (n x q) Numeric covariate matrix.
#' @param v Scalar residual variance.
#'
#' @return Scalar score statistic.
Score <- function(y, G, X, v) {
    .Call(`_AllelicSeries_Score`, y, G, X, v)
}

#' Calculate SKAT Weights
#' @param anno (snps x 1) annotation vector with values in c(0, 1, 2).
#' @param maf (snps x 1) vector of minor allele frequencies.
#' @param weights (3 x 1) vector of annotation category weights.
#' @return (snps x 1) vector of weights for SKAT test.
#' @noRd 
CalcSkatWeights <- function(anno, maf, weights) {
    .Call(`_AllelicSeries_CalcSkatWeights`, anno, maf, weights)
}

#' Get SKAT Eigenvalues
#' @param kernel Symmetric matrix.
#' @return Vector of eigenvalues.
#' @noRd
GetLambda <- function(kernel) {
    .Call(`_AllelicSeries_GetLambda`, kernel)
}

#' SKAT Optimal Parameters
#' @param cov_z Covariance of the Z-scores
#' @param rhos Vector of rho values to evaluate.
#' @return List of optimal parameter values.
#' @noRd 
SkatOptimalParam <- function(cov_z, rhos) {
    .Call(`_AllelicSeries_SkatOptimalParam`, cov_z, rhos)
}

#' Correlation C++
#' 
#' @section Notes:
#' Verified this function is faster that R's built-in correlation function
#' for large genotype matrices.
#'
#' @param x Numeric matrix.
#' @return Numeric matrix of correlation among the columns.
CorCpp <- function(x) {
    .Call(`_AllelicSeries_CorCpp`, x)
}

#' Check if Positive Definite
#'
#' @param x Numeric matrix.
#' @param force_symmetry Force the matrix to be symmetric?
#' @param tau Threshold the minimum eigenvalue must exceed for the matrix
#'   to be considered positive definite. 
#' @return Logical indicating whether the matrix is PD.
#' @export 
isPD <- function(x, force_symmetry = FALSE, tau = 1e-8) {
    .Call(`_AllelicSeries_isPD`, x, force_symmetry, tau)
}

AnnoMat <- function(anno) {
    .Call(`_AllelicSeries_AnnoMat`, anno)
}

#' Baseline Counts Test from Sumstats
#'
#' @param anno (snps x 1) annotation vector.
#' @param beta (snps x 1) vector of effect sizes for 
#'   the coding genetic variants within a gene.
#' @param ld (snps x snps) matrix of correlations among the genetic variants.
#' @param se (snps x 1) vector of standard errors for the effect sizes.
#' @return Numeric p-value.
#' @export
BaselineSS <- function(anno, beta, ld, se) {
    .Call(`_AllelicSeries_BaselineSS`, anno, beta, ld, se)
}

#' Allelic Sum Test from Sumstats
#'
#' @param anno (snps x 1) annotation vector.
#' @param beta (snps x 1) vector of effect sizes for 
#'   the coding genetic variants within a gene.
#' @param ld (snps x snps) matrix of correlations among the genetic variants.
#' @param se (snps x 1) vector of standard errors for the effect sizes.
#' @param weights (3 x 1) vector of annotation category weights.
#' @return Numeric p-value.
#' @export
SumCountSS <- function(anno, beta, ld, se, weights) {
    .Call(`_AllelicSeries_SumCountSS`, anno, beta, ld, se, weights)
}

