% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/founderPop.R
\name{runMacs}
\alias{runMacs}
\title{Create founder haplotypes using MaCS}
\usage{
runMacs(nInd, nChr = 1, segSites = NULL, inbred = FALSE,
  species = "GENERIC", split = NULL, ploidy = 2L,
  manualCommand = NULL, manualGenLen = NULL, nThreads = NULL)
}
\arguments{
\item{nInd}{number of individuals to simulate}

\item{nChr}{number of chromosomes to simulate}

\item{segSites}{number of segregating sites to keep per chromosome. A 
value of NULL results in all sites being retained.}

\item{inbred}{should founder individuals be inbred}

\item{species}{species history to simulate. See details.}

\item{split}{an optional historic population split in terms of generations ago.}

\item{ploidy}{ploidy level of organism}

\item{manualCommand}{user provided MaCS options. For advanced users only.}

\item{manualGenLen}{user provided genetic length. This must be supplied if using 
manualCommand. If not using manualCommand, this value will replace the predefined 
genetic length for the species. However, this the genetic length is only used by 
AlphaSimR and is not passed to MaCS, so MaCS still uses the predefined genetic length. 
For advanced users only.}

\item{nThreads}{if OpenMP is available, this will allow for simulating chromosomes in parallel. 
If the value is NULL, the number of threads is automatically detected.}
}
\value{
an object of \code{\link{MapPop-class}}
}
\description{
Uses the MaCS software to produce founder haplotypes.
}
\details{
The current species histories are included: GENERIC, CATTLE, WHEAT, MAIZE,  
and EUROPEAN.
}
\examples{
# Creates a populations of 10 outbred individuals
# Their genome consists of 1 chromosome and 100 segregating sites
founderPop = runMacs(nInd=10,nChr=1,segSites=100)

}
