% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\docType{class}
\name{Pop-class}
\alias{Pop-class}
\alias{[,Pop-method}
\alias{c,Pop-method}
\alias{show,Pop-method}
\title{Population}
\usage{
\S4method{[}{Pop}(x, i)

\S4method{c}{Pop}(x, ...)

\S4method{show}{Pop}(object)
}
\arguments{
\item{x}{a 'Pop' object}

\item{i}{index of individuals}

\item{...}{additional 'Pop' objects}

\item{object}{a 'Pop' object}
}
\description{
Extends \code{\link{RawPop-class}} to add sex, genetic values, 
phenotypes, and pedigrees.
}
\section{Methods (by generic)}{
\itemize{
\item \code{[}: Extract Pop by index or id

\item \code{c}: Combine multiple Pops

\item \code{show}: Show population summary
}}

\section{Slots}{

\describe{
\item{\code{id}}{an individual's identifier}

\item{\code{mother}}{the identifier of the individual's mother}

\item{\code{father}}{the identifier of the individual's father}

\item{\code{sex}}{sex of individuals: "M" for males, "F" for females,
and "H" for hermaphrodites}

\item{\code{nTraits}}{number of traits}

\item{\code{gv}}{matrix of genetic values. When using GxE traits,
gv reflects gv when w=0. Dimensions are nInd by nTraits.}

\item{\code{pheno}}{matrix of phenotypic values. Dimensions are
nInd by nTraits.}

\item{\code{ebv}}{matrix of estimated breeding values. Dimensions 
are nInd rows and a variable number of columns.}

\item{\code{gxe}}{list containing GxE slopes for GxE traits}

\item{\code{fixEff}}{a fixed effect relating to the phenotype. 
Used by genomic selection models but otherwise ignored.}

\item{\code{reps}}{the number of replications used to measure the 
phenotype. Used by genomic selection models, but otherwise ignored.}

\item{\code{misc}}{a list whose elements correspond to individuals in the 
population. This list is normally empty and exists solely as an 
open slot available for uses to store extra information about 
individuals.}
}}

