% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{solveRRBLUP_EM3}
\alias{solveRRBLUP_EM3}
\title{Solve RR-BLUP with EM and 3 random effects}
\usage{
solveRRBLUP_EM3(Y, X, M1, M2, M3, Vu1, Vu2, Vu3, Ve, tol, maxIter, useEM)
}
\arguments{
\item{Y}{a matrix with n rows and 1 column}

\item{X}{a matrix with n rows and x columns}

\item{M1}{a matrix with n rows and m1 columns}

\item{M2}{a matrix with n rows and m2 columns}

\item{M3}{a matrix with n rows and m3 columns}

\item{Vu1}{initial guess for variance of the first marker effects}

\item{Vu2}{initial guess for variance of the second marker effects}

\item{Vu3}{initial guess for variance of the second marker effects}

\item{Ve}{initial guess for error variance}

\item{tol}{tolerance for declaring convergence}

\item{maxIter}{maximum iteration for attempting convergence}

\item{useEM}{should EM algorithm be used. If false, no estimation of
variance components is performed. The initial values are treated as true.}
}
\description{
Solves a univariate mixed model of form \eqn{y=X\beta+M_1u_1+M_2u_2+M_3u_3+e} using
the Expectation-Maximization algorithm.
}
