% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r
\name{c}
\alias{c}
\alias{c.AmigaBitmapFont}
\title{Combine AmigaBitmapFont objects into an AmigaBitmapFontSet}
\usage{
\method{c}{AmigaBitmapFont}(..., name = "font")
}
\arguments{
\item{...}{One or more \code{\link{AmigaBitmapFont}} objects that need
to becombined into a single \code{\link{AmigaBitmapFontSet}} object.
Each \code{\link{AmigaBitmapFont}} object should have a
unique Y-size.}

\item{name}{A \code{character} string specifying the name that needs to be
applied to the font set. When unspecified, the default name 'font' is
used. Note that this name will also be used as a file name when writing
the font to a file. So make sure the name is also a valid file name. This
will not be checked for you.}
}
\value{
Returns an \code{link{AmigaBitmapFontSet}} in which the
\code{\link{AmigaBitmapFont}} objects are combined.
}
\description{
Use this function to correctly combine one or more \code{\link{AmigaBitmapFont}}
class objects into a single \code{\link{AmigaBitmapFontSet}} class
object.
}
\details{
\code{\link{AmigaBitmapFontSet}} class objects can hold multiple
\code{\link{AmigaBitmapFont}} class objects. Use this method to
combine font bitmaps into such a font set. Make sure each bitmap
represents a unique font height (in pixels). When heights are duplicated
an error will be thrown.

You can also specify a \code{name} for the font, that will be embeded
in the object. As this name will also be used as a file name when
writing the font to a file, make sure that it is a valid filename.
}
\examples{
\dontrun{
data(font_example)

## first get some AmigaBitmapFont objects:
font8 <- getAmigaBitmapFont(font_example, 8)
font9 <- getAmigaBitmapFont(font_example, 9)

## now bind these bitmaps again in a single set
font.set <- c(font8, font9, name = "my_font_name")
}
}
\seealso{
Other AmigaBitmapFont.operations: \code{\link{AmigaBitmapFont}},
  \code{\link{availableFontSizes}}, \code{\link{fontName}},
  \code{\link{font_example}},
  \code{\link{getAmigaBitmapFont}},
  \code{\link{rasterToAmigaBitmapFont}},
  \code{\link{rawToAmigaBitmapFontSet}},
  \code{\link{rawToAmigaBitmapFont}},
  \code{\link{read.AmigaBitmapFontSet}},
  \code{\link{read.AmigaBitmapFont}},
  \code{\link{write.AmigaBitmapFont}}
}
\author{
Pepijn de Vries
}
